package com.qiho.center.biz.service.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.biz.service.ItemDetailRecordService;
import com.qiho.center.common.daoh.qiho.QihoItemDetailRecordMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanDetailMapper;
import com.qiho.center.common.entityd.qiho.QihoItemDetailRecordEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanDetailEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/10/23.
 */
@Service
public class ItemDetailRecordServiceImpl implements ItemDetailRecordService{

	@Resource
	QihoTestPlanDetailMapper qihoTestPlanDetailMapper;

	@Resource
    QihoItemDetailRecordMapper  qihoItemDetailRecordMapper;

	@Override
	public Long getDetailRecordId(Long itemId, String planCode) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("itemId",itemId);
		if(StringUtils.isBlank(planCode)){
			map.put("sourceType",1);
		}else{
			map.put("sourceType",2);
			List<QihoTestPlanDetailEntity> detailEntityList = qihoTestPlanDetailMapper.selectListByCode(planCode);
			detailEntityList.stream().forEach(detail->{
				if(detail.getMetadataKey().equals(MetadataTypeEnum.DETAIL.getCode())){
					map.put("sourceId",detail.getMetadataId());
				}
			});
		}
		QihoItemDetailRecordEntity entity = qihoItemDetailRecordMapper.selectByField(map);
		return null != entity ? entity.getId() : null;
	}

	@Override
	public int addDetailRecord(QihoItemDetailRecordEntity entity) {
		return qihoItemDetailRecordMapper.insert(entity);
	}

	@Override
	public QihoItemDetailRecordEntity selectById(Long id) {
		return qihoItemDetailRecordMapper.selectById(id);
	}
}
