package com.qiho.center.biz.service.impl.component;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;
import com.qiho.center.biz.service.component.ComponentService;
import com.qiho.center.common.daoh.qiho.component.BaiqiComponentMapper;
import com.qiho.center.common.entityd.qiho.component.BaiqiComponentEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2018-07-24
 */
@Service
public class ComponentServiceImpl implements ComponentService {

    private static final Transformer TRANSFORMER = new Transformer();

    @Autowired
    private BaiqiComponentMapper baiqiComponentMapper;



    @Override
    public ComponentDto findById(Long id) {
        if (id == null || id <= 0) {
            return null;
        }

        BaiqiComponentEntity componentEntity = baiqiComponentMapper.findById(id);
        if (componentEntity == null) {
            return null;
        }

        ComponentDto componentDto = TRANSFORMER.apply(componentEntity);
        return componentDto;
    }

    @Override
    public ResultDto<Long> createComponent(ComponentDto component) {
        if (component == null) {
            return ResultDto.failResult("传入数据为空");
        }

        BaiqiComponentEntity componentEntity = BeanUtils.copy(component, BaiqiComponentEntity.class);
        componentEntity.setComponentType(component.getComponentType().getNum());
        baiqiComponentMapper.insertComponent(componentEntity);

        return ResultDto.successResult(componentEntity.getId());
    }

    @Override
    public ResultDto<Long> updateComponent(ComponentDto component) {
        if (component == null) {
            return ResultDto.failResult("传入数据为空");
        }

        BaiqiComponentEntity componentEntity = BeanUtils.copy(component, BaiqiComponentEntity.class);
        componentEntity.setComponentType(component.getComponentType().getNum());
        baiqiComponentMapper.updateComponentById(componentEntity);

        return ResultDto.successResult(componentEntity.getId());
    }

    @Override
    public List<ComponentDto> listByType(ComponentTypeEnum type) {
        if (type == null) {
            return Lists.newArrayList();
        }

        Integer num = type.getNum();
        List<BaiqiComponentEntity> componentEntityList = baiqiComponentMapper.listByType(num);
        List<ComponentDto> list = componentEntityList.stream().map(TRANSFORMER).collect(Collectors.toList());

        return list;
    }

    @Override
    public List<ComponentDto> listBatchByIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }

        List<BaiqiComponentEntity> componentEntities = baiqiComponentMapper.listByIds(idList);
        List<ComponentDto> list = componentEntities.stream().map(TRANSFORMER).collect(Collectors.toList());

        return list;
    }



    /**
     * 类型转换
     * convert {@link BaiqiComponentEntity} to {@link ComponentDto}
     */
    private static class Transformer implements Function<BaiqiComponentEntity, ComponentDto> {

        @Override
        public ComponentDto apply(BaiqiComponentEntity entity) {
            if (entity == null) {
                return null;
            }
            ComponentDto dto = BeanUtils.copy(entity, ComponentDto.class);
            dto.setComponentType(ComponentTypeEnum.getByNum(entity.getComponentType()));
            return dto;
        }
    }



}
