package com.qiho.center.biz.service.impl.embed;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.embed.EmbedDto;
import com.qiho.center.biz.service.embed.EmbedService;
import com.qiho.center.common.daoh.qiho.embed.BaiqiEmbedMapper;
import com.qiho.center.common.entity.embed.BaiqiEmbedEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author chensong
 * @create 2018-02-27 16:20
 **/
@Service
public class EmbedServiceImpl implements EmbedService {

    @Autowired
    private BaiqiEmbedMapper baiqiEmbedMapper;

    @Override
    public Boolean insert(EmbedDto dto) {
        if (Objects.equals(dto, null) || Objects.equals(dto.getResult(), null)) {
            return Boolean.FALSE;
        }
        BaiqiEmbedEntity entity = BeanUtils.copy(dto, BaiqiEmbedEntity.class);
        entity.setResult(dto.getResult().getNum());
        return baiqiEmbedMapper.insert(entity) == 1;
    }
}
