package com.qiho.center.biz.service.impl.finance.bean;

import com.qiho.center.api.enums.finance.CashRebateAmountEnum;

import java.util.Objects;

/**
 * CashRebateAmountBo
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-27 18:30
 */
public class CashRebateAmountBean {

    /**
     * 总金额
     */
    private Long totalAmount;

    /**
     * 现金金额
     */
    private Long cashAmount;

    /**
     * 返点金额
     */
    private Long rebateAmount;

    /**
     * 操作类型:1=存入，2=支出 {@link CashRebateAmountEnum#code}
     */
    private CashRebateAmountEnum opType;

    public Long getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Long getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getRebateAmount() {
        return rebateAmount;
    }

    public void setRebateAmount(Long rebateAmount) {
        this.rebateAmount = rebateAmount;
    }

    public CashRebateAmountEnum getOpType() {
        return opType;
    }

    public void setOpType(CashRebateAmountEnum opType) {
        this.opType = opType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        CashRebateAmountBean that = (CashRebateAmountBean) o;
        return Objects.equals(totalAmount, that.totalAmount) && Objects.equals(cashAmount, that.cashAmount) && Objects
            .equals(rebateAmount, that.rebateAmount) && opType == that.opType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(totalAmount, cashAmount, rebateAmount, opType);
    }

    @Override
    public String toString() {
        return "CashRebateAmountBo{" + "totalAmount=" + totalAmount + ", cashAmount=" + cashAmount + ", rebateAmount="
            + rebateAmount + ", opType=" + opType + '}';
    }
}
