package com.qiho.center.biz.service.impl.finance.bean;

import com.qiho.center.api.enums.finance.TuiaTradeTypeEnum;

import java.util.Objects;

/**
 * 外部接口参数
 *
 * @author zhangshun
 * @version V1.0
 * @since 2018-01-03 11:11
 */
public class PartnerAllocateAmountBean {

    /**
     * 交易号
     */
    private String baiqiTradeNo;

    /**
     * 交易类型 1-划账 2-回拨
     */
    private TuiaTradeTypeEnum tradeType;

    /**
     * 广告主ID
     */
    private Long accountId;

    /**
     * 金额
     */
    private Long amount;

    public String getBaiqiTradeNo() {
        return baiqiTradeNo;
    }

    public void setBaiqiTradeNo(String baiqiTradeNo) {
        this.baiqiTradeNo = baiqiTradeNo;
    }

    public TuiaTradeTypeEnum getTradeType() {
        return tradeType;
    }

    public void setTradeType(TuiaTradeTypeEnum tradeType) {
        this.tradeType = tradeType;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        PartnerAllocateAmountBean that = (PartnerAllocateAmountBean) o;
        return tradeType == that.tradeType && Objects.equals(baiqiTradeNo, that.baiqiTradeNo) && Objects
            .equals(accountId, that.accountId) && Objects.equals(amount, that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(baiqiTradeNo, tradeType, accountId, amount);
    }

    @Override
    public String toString() {
        return "PartnerAllocateAmountBean{" + "baiqiTradeNo='" + baiqiTradeNo + '\'' + ", tradeType=" + tradeType
            .getName() + ", accountId=" + accountId + ", amount=" + amount + '}';
    }
}
