package com.qiho.center.biz.service.impl.logistics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.qiho.center.biz.service.logistics.ExpressBirdService;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiExpressCodeMappingMapper;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiExpressCodeMappingEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.util.ExpressBirdProvideUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

/**
 * @author: wangjin
 * @create 2018-06-11 11:17
 **/
@Service
public class ExpressBirdServiceImpl implements ExpressBirdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressBirdServiceImpl.class);

    @Value("${kuaidiniao.express.key}")
    private static String key;

    @Autowired
    private BaiqiLogisticsMapper baiqiLogisticsMapper;
    @Autowired
    private BaiqiExpressCodeMappingMapper baiqiExpressCodeMapper;

    //存放所有百奇物流公司code对应的快递鸟物流缓存
    private static final String BAQILOGISTICSCODE_EXPRESSBIRDLOGISTICS_KEY = "baqiLogisticsCode_ExpressBirdLogistics_{0}";
    private static final Cache<String,BaiqiExpressCodeMappingEntity> baiqi_expressBird_LogisticsLocalCache = CacheBuilder.newBuilder().
            maximumSize(100).expireAfterWrite(15, TimeUnit.MINUTES).build();


    @Override
    public boolean checkExpressSign(String sign,String resData) {
        try{
            String createSign = ExpressBirdProvideUtil.encrypt(resData, key, "UTF-8");
            return sign.equals(createSign);
        }catch (Exception e){
            LOGGER.warn("快递鸟签名校验失败,error:" + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean dealExpressStatus(String code, String postId, String status) {
        return false;
    }

    @Override
    public BaiqiExpressCodeMappingEntity findByBaiqiLogisticsCode(String logisticsCode, String expressPlatform) {
        String key = MessageFormat.format(BAQILOGISTICSCODE_EXPRESSBIRDLOGISTICS_KEY,logisticsCode);
        BaiqiExpressCodeMappingEntity entity = baiqi_expressBird_LogisticsLocalCache.getIfPresent(key);
        if (entity == null){
            BaiqiLogisticsEntity baiqiLogisticsEntity  = baiqiLogisticsMapper.findByCode(logisticsCode);
            if (baiqiLogisticsEntity != null){
                entity = baiqiExpressCodeMapper.findByBaiqiLogisticsCodeAndCompany(baiqiLogisticsEntity.getId(),expressPlatform);
                baiqi_expressBird_LogisticsLocalCache.put(key,entity);
            }
        }
        return entity;
    }


}
