package com.qiho.center.biz.service.impl.logistics;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiho.center.biz.service.logistics.LogisticsSubscribeService;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsSubscribeMapper;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsSubscribeSuccessMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsSubscribeEntity;

/**
 * @author: wangjin
 * @create 2018-06-13 14:07
 **/
@Service
public class LogisticsSubscribeServiceImpl implements LogisticsSubscribeService {

    @Resource
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
    @Resource
    private BaiqiLogisticsSubscribeSuccessMapper subscribeSuccessMapper;
    @Resource
    private BaiqiLogisticsSubscribeMapper subscribeMapper;

    /**
     * 订阅的返回码
     */
    private static final int RETURN_CODE = 9999;


    @Override
    public int insertLogisticsSubscribe(BaiqiLogisticsSubscribeEntity entity) {
        return subscribeMapper.insertLogisticsSubscribe(entity);
    }

    @Override
    public int countLogisticsSubscribe(String postId) {
        return subscribeMapper.countLogisticsSubscribe(postId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void changeLogisticsSubscribe(BaiqiLogisticsSubscribeEntity entity) {

        qihoLogisticsOrderDAO.updatePostReturnCode(RETURN_CODE, entity.getPostId());

        //如果订阅表中有信息，删除订阅表中的信息
        subscribeMapper.deleteLogisticsSubscribe(entity.getPostId());

        //插入订阅成功信息表中
        subscribeSuccessMapper.insertLogisticsSubscribeSuccess(entity);
    }
}
