package com.qiho.center.biz.service.impl.order;

import com.qiho.center.api.dto.discount.OrderDiscountDto;
import com.qiho.center.biz.service.order.OrderDiscountService;
import com.qiho.center.common.daoh.qiho.discount.BaiqiOrderDiscountMapper;
import com.qiho.center.common.entityd.qiho.discount.BaiqiOrderDiscountEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author chensong
 * @create 2018-09-05
 */
@Service
public class OrderDiscountServiceImpl implements OrderDiscountService {

    @Autowired
    private BaiqiOrderDiscountMapper baiqiOrderDiscountMapper;


    @Override
    public void insertDiscountOrder(OrderDiscountDto orderDiscount, String orderId) {
        if (orderDiscount == null) {
            return;
        }

        BaiqiOrderDiscountEntity entity = new BaiqiOrderDiscountEntity();
        entity.setOrderId(orderId);
        entity.setDiscountType(orderDiscount.getDiscountType().getValue());
        entity.setDiscountValue(orderDiscount.getDiscountValue());
        entity.setUseType(orderDiscount.getUseType().getValue());
        entity.setUseThreshold(orderDiscount.getUseThreshold());
        entity.setRemark(orderDiscount.getRemark());
        baiqiOrderDiscountMapper.insert(entity);
    }






}
