package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.SecurityUtils;
import com.qiho.center.biz.service.order.OrderTokenService;
import com.qiho.center.common.daoh.qiho.order.BaiqiOrderTokenMapper;
import com.qiho.center.common.entityd.qiho.order.BaiqiOrderTokenEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author chensong
 * @create 2018-08-06
 */
@Service
@Deprecated
public class OrderTokenServiceImpl implements OrderTokenService {

    /** 订单id加盐部分 */
    private static final String ORDER_SALT = "妖精！快还我爷爷！";

    @Autowired
    private BaiqiOrderTokenMapper baiqiOrderTokenMapper;


    @Override
    public String generateOrderToken(String orderId) {
        String token = SecurityUtils.encode2StringByMd5(orderId + ORDER_SALT);

        BaiqiOrderTokenEntity entity = new BaiqiOrderTokenEntity();
        entity.setOrderId(orderId);
        entity.setToken(token);
        baiqiOrderTokenMapper.insert(entity);

        return token;
    }

    @Override
    public String getTokenWithUnexist(String orderId) {
        BaiqiOrderTokenEntity entity = baiqiOrderTokenMapper.findByOrderId(orderId);
        if (entity != null) {
            return entity.getToken();
        }

        String token = SecurityUtils.encode2StringByMd5(orderId + ORDER_SALT);
        entity = new BaiqiOrderTokenEntity();
        entity.setOrderId(orderId);
        entity.setToken(token);
        baiqiOrderTokenMapper.insert(entity);

        return token;
    }

    @Override
    public String getOrderIdByToken(String token) {
        if (StringUtils.isBlank(token)) {
            return null;
        }

        BaiqiOrderTokenEntity entity = baiqiOrderTokenMapper.findByToken(token);
        if (Objects.equals(entity, null)) {
            return null;
        }

        return entity.getOrderId();
    }


}
