package com.qiho.center.biz.service.impl.orderexport;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.orderexport.FieldDto;
import com.qiho.center.api.dto.orderexport.TemplateFieldDto;
import com.qiho.center.biz.service.orderexport.OrderExportTemplateFieldService;
import com.qiho.center.common.daoh.qiho.orderexport.QihoFieldMapper;
import com.qiho.center.common.daoh.qiho.orderexport.QihoOrderExportTemplateFieldMapper;
import com.qiho.center.common.entityd.qiho.orderexport.QihoFieldEntity;
import com.qiho.center.common.entityd.qiho.orderexport.QihoOrderExportTemplateFieldEntity;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

/**
 * 订单导出模板字段service实现
 *
 * @author peanut.huang
 * @date 2017/11/27.
 */
@Service("orderExportTemplateFieldService")
public class OrderExportTemplateFieldServiceImpl implements OrderExportTemplateFieldService {

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderExportTemplateFieldServiceImpl.class);

    @Resource
    private QihoOrderExportTemplateFieldMapper templateFieldMapper;
    @Resource
    private QihoFieldMapper qihoFieldMapper;

    @Override
    public TemplateFieldDto findById(Long tempFieldId) {
        if(tempFieldId == null){
            LOGGER.error("find temp field failed: tempFieldId is null");
            return null;
        }

        //1、查询模板字段属性
        QihoOrderExportTemplateFieldEntity templateFieldEntity = templateFieldMapper.findById(tempFieldId);
        if(templateFieldEntity == null){
            return null;
        }

        //字段id
        Long fieldId = templateFieldEntity.getFieldId();

        TemplateFieldDto result = BeanUtils.copy(templateFieldEntity, TemplateFieldDto.class);

        //2、查询字段属性
        QihoFieldEntity fieldEntity = qihoFieldMapper.findById(fieldId);
        if(fieldEntity != null){
            result.setFieldName(fieldEntity.getFieldName());
            result.setFieldValue(fieldEntity.getFieldValue());
        }

        return result;
    }

    @Override
    public List<TemplateFieldDto> findByTempId(Long tempId) {
        if(tempId == null){
            LOGGER.error("find by tempId failed: tempId is null");
            return Collections.emptyList();
        }

        //查询模板字段
        List<QihoOrderExportTemplateFieldEntity> templateFieldList = templateFieldMapper.findByTempId(tempId);
        if(CollectionUtils.isEmpty(templateFieldList)){
            return Collections.emptyList();
        }

        List<TemplateFieldDto> result = BeanUtils.copyList(templateFieldList, TemplateFieldDto.class);

        //查询字段属性
        for(TemplateFieldDto templateFieldDto : result){

            //字段id
            Long fieldId = templateFieldDto.getFieldId();

            QihoFieldEntity fieldEntity = qihoFieldMapper.findById(fieldId);
            if(fieldEntity != null){
                templateFieldDto.setFieldName(fieldEntity.getFieldName());
                templateFieldDto.setFieldValue(fieldEntity.getFieldValue());
            }
        }

        return result;
    }

    @Override
    public Boolean deleteById(Long tempFieldId) {
        if(tempFieldId == null){
            LOGGER.error("delete temp field failed: tempFieldId is null");
            return false;
        }

        return templateFieldMapper.deleteById(tempFieldId) > 0;
    }

    @Override
    public Boolean saveTempField(TemplateFieldDto templateFieldDto) {

        QihoOrderExportTemplateFieldEntity templateFieldEntity = BeanUtils.copy(templateFieldDto, QihoOrderExportTemplateFieldEntity.class);

        //
        if(templateFieldEntity == null){
            return false;
        }

        Long id = templateFieldEntity.getId();

        if(id == null){

            //insert

            return templateFieldMapper.insert(templateFieldEntity) > 0;
        }else {

            //update

            return templateFieldMapper.update(templateFieldEntity) > 0;
        }
    }

    @Override
    public List<FieldDto> findField4Select() {
        List<QihoFieldEntity> listAll = qihoFieldMapper.findAll();
        return BeanUtils.copyList(listAll, FieldDto.class);
    }
}
