package com.qiho.center.biz.service.impl.orderexport;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.orderexport.OrderExportTemplateDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;
import com.qiho.center.biz.service.orderexport.OrderExportTemplateService;
import com.qiho.center.common.daoh.qiho.orderexport.QihoOrderExportTemplateFieldMapper;
import com.qiho.center.common.daoh.qiho.orderexport.QihoOrderExportTemplateMapper;
import com.qiho.center.common.entityd.qiho.orderexport.QihoOrderExportTemplateEntity;
import com.qiho.center.common.entityd.qiho.orderexport.QihoOrderExportTemplateFieldEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 订单导出模板service实现
 *
 * @author peanut.huang
 * @date 2017/11/27.
 */
@Service("orderExportTemplateService")
public class OrderExportTemplateServiceImpl implements OrderExportTemplateService {

    @Resource
    private QihoOrderExportTemplateMapper orderExportTemplateMapper;
    @Resource
    private QihoOrderExportTemplateFieldMapper orderExportTemplateFieldMapper;

    @Override
    public PagenationDto<OrderExportTemplateDto> find4Page(OrderExportTemplateQueryParams templateQueryParams) {

        //模板名称
        String tempName = templateQueryParams.getTempName();

        Integer offset = templateQueryParams.getOffset();
        Integer max = templateQueryParams.getMax();

        PagenationDto<OrderExportTemplateDto> result = new PagenationDto<>();

        //1、分页查询
        List<QihoOrderExportTemplateEntity> orderExportTemplateList = orderExportTemplateMapper.find4Page(tempName, offset, max);
        if(CollectionUtils.isEmpty(orderExportTemplateList)){
            return result;
        }

        //2、查总数
        int count = orderExportTemplateMapper.count4Page(tempName);

        List<OrderExportTemplateDto> resultList = Lists.newArrayListWithExpectedSize(orderExportTemplateList.size());

        //3、循环处理
        orderExportTemplateList.forEach( e -> {

            //构建dto
            OrderExportTemplateDto exportTemplateDto = buildTempDto(e);

            resultList.add(exportTemplateDto);
        });

        //4、设置总数与列表
        result.setTotal(count);
        result.setList(resultList);

        return result;
    }

    @Override
    public Boolean save(Long id, String tempName) {
        QihoOrderExportTemplateEntity templateEntity = new QihoOrderExportTemplateEntity();
        templateEntity.setTempName(tempName);
        templateEntity.setId(id);

        if(id == null){
           return orderExportTemplateMapper.insert(templateEntity) > 0;
        }else {
           return orderExportTemplateMapper.update(templateEntity) > 0;
        }
    }

    @Override
    public Boolean deleteById(Long id) {
        Preconditions.checkNotNull(id);

        //删除模板本身
        orderExportTemplateMapper.deleteById(id);

        //删除模板与字段关联
        orderExportTemplateFieldMapper.deleteByTempId(id);

        return true;
    }

    @Override
    public List<OrderExportTemplateDto> findTemp4Select() {
       List<QihoOrderExportTemplateEntity> allTemp = orderExportTemplateMapper.findAllWithIdAndName();

       return BeanUtils.copyList(allTemp, OrderExportTemplateDto.class);
    }

    /**
     * 构建模板返回dto
     *
     *
     * @param templateEntity
     * @return
     */
    private OrderExportTemplateDto buildTempDto(QihoOrderExportTemplateEntity templateEntity) {

        //模板id
        Long tempId =  templateEntity.getId();

        OrderExportTemplateDto result = BeanUtils.copy(templateEntity, OrderExportTemplateDto.class);


        //获取模板对应的字段
        List<QihoOrderExportTemplateFieldEntity>  templateFieldList = orderExportTemplateFieldMapper.findByTempId(tempId);
        if(CollectionUtils.isEmpty(templateFieldList)){
            return result;
        }

        //外部名称集
        String outerNames = templateFieldList.stream()
                                             .map(QihoOrderExportTemplateFieldEntity::getOuterName)
                                             .collect(Collectors.joining("|"));


        result.setTempFields(outerNames);

        return result;
    }
}
