package com.qiho.center.biz.service.impl.ordersms;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qiho.center.api.constant.YZHSmsConstant;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordersms.OrderSmsReceiveStatus;
import com.qiho.center.api.enums.ordersms.OrderSmsSendStatusEnum;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.biz.service.ordersms.OrderSmsService;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import com.qiho.center.common.support.ShortUrlProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author chensong
 * @create 2018-05-21 19:27
 **/
@Service
public class OrderSmsServiceImpl implements OrderSmsService{

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderSmsServiceImpl.class);


    @Autowired
    private MediaWhiteListService mediaWhiteListService;

    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;

    @Autowired
    private SmsService smsService;

    @Autowired
    private ShortUrlProvider shortUrlProvider;

    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;

    @Autowired
    private ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;

    @Autowired
    private SequenceNoBuilder sequenceNoBuilder;

    @Override
    public SmsTypeEnum sendMessage(OrderTmpDetailDto orderTmpDetailDto){
        // 订单编号
        String orderId = orderTmpDetailDto.getOrderId();
        // 商品简称
        String itemShortName = orderTmpDetailDto.getItemShortName();
        // 下单短信里的短连接
        String shortUrl = shortUrlProvider.saveShortUrl(orderId);
        // 手机号
        String mobile = orderTmpDetailDto.getMobile();

        // 获取下单模板
        QihoTemplateEntity template = qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCCESS.getCode());

        SmsTypeEnum smsTypeEnum = null;
        // 发送短信
        if (null != template && template.getTemplateEnable()) {
            Map<String, String> context = Maps.newHashMap();
            context.put("orderDetailUrl", shortUrl);
            context.put("itemName", itemShortName);
            smsTypeEnum = SmsTypeEnum.fromCode(template.getSmsType());

            String smsRetCode = YZHSmsConstant.YZHCODE.UNKNOWN;
            try {
                template.setReport(true);
                smsRetCode = smsService.singleSendRetCode(template, context, mobile);

                // 记录下单短信 tb_baiqi_order_sms
                saveOrderSms(orderId, mobile, smsTypeEnum, smsRetCode, OrderSmsSendStatusEnum.SUCCESS);
            } catch (Exception e) {
                LOGGER.error("发送短信错误,orderId: {} ,smsTemplate:{}", orderId, template, e);
                saveOrderSms(orderId, mobile, smsTypeEnum, smsRetCode, OrderSmsSendStatusEnum.FAIL);
            }

        } else {
            LOGGER.error("下单短信模板错误，orderId： {} ，smsTemplate:{}",orderId, template);
            smsTypeEnum = saveOrderSmsFail(orderId, mobile);
        }

        // 发送下单温馨提示
        QihoTemplateEntity remindTemplate = qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_NOTIFY.getCode());
        if (remindTemplate.getTemplateEnable()) {
            smsService.singleSend(remindTemplate, mobile);
        }

        return smsTypeEnum;
    }


    /**
     *  一个临时处理措施，当短信通道关闭时在order_sms和chuanglan_commit表插入伪数据，
     * 以确保订单还能通过短信超时的定时任务进行状态流转
     * 默认使用创蓝的短信通道
     * @param orderId
     * @param mobile
     */
    private SmsTypeEnum saveOrderSmsFail(String orderId, String mobile){
        SmsTypeEnum smsTypeEnum  = SmsTypeEnum.CHUANG_LAN;

        // 13位时间戳+4位序列编码
        String msgId = Long.valueOf(System.currentTimeMillis()) + sequenceNoBuilder.getSequenceValue(SeqBizTypeEnum.SMS);

        // insert tb_baiqi_order_sms 表
        BaiqiOrderSmsEntity orderSmsEntity = new BaiqiOrderSmsEntity();
        orderSmsEntity.setMobile(mobile);
        orderSmsEntity.setSmsType(smsTypeEnum.getNum());
        orderSmsEntity.setOrderId(orderId);
        orderSmsEntity.setSendStatus(OrderSmsSendStatusEnum.FAIL.getNum());
        if (smsTypeEnum.isNeedReport()) {
            orderSmsEntity.setReceiveStatus(OrderSmsReceiveStatus.UNPROCESSES.getNum());
        } else {
            orderSmsEntity.setReceiveStatus(OrderSmsReceiveStatus.PROCESSES.getNum());
        }
        orderSmsEntity.setMsgId(msgId);
        baiqiOrderSmsMapper.insertOrderSms(orderSmsEntity);

        // insert tb_qiho_chuanglan_sms_commit
        ChuangLanSmsCommitEntity smsCommitEntity = new ChuangLanSmsCommitEntity();
        smsCommitEntity.setOrderId(orderId);
        smsCommitEntity.setMsgId(msgId);
        smsCommitEntity.setHandlerStatus(0);
        chuangLanSmsCommitMapper.insert(smsCommitEntity);

        return smsTypeEnum;
    }

    /**
     * 记录下单短信
     * @param orderId 订单编号
     * @param mobile 手机号
     * @param smsTypeEnum 短信服务商类型
     * @param smsRetCode 服务商的返回结果
     */
    private void saveOrderSms(String orderId, String mobile, SmsTypeEnum smsTypeEnum, String smsRetCode, OrderSmsSendStatusEnum snedStatus){
        BaiqiOrderSmsEntity orderSmsEntity = new BaiqiOrderSmsEntity();
        orderSmsEntity.setMobile(mobile);
        orderSmsEntity.setSmsType(smsTypeEnum.getNum());
        orderSmsEntity.setOrderId(orderId);
        orderSmsEntity.setSendStatus(snedStatus.getNum());

        //  是否需要接收短信报告
        if (smsTypeEnum.isNeedReport()) {
            orderSmsEntity.setReceiveStatus(OrderSmsReceiveStatus.UNPROCESSES.getNum());
        } else {
            orderSmsEntity.setReceiveStatus(OrderSmsReceiveStatus.PROCESSES.getNum());
        }

        if (smsTypeEnum == SmsTypeEnum.CHUANG_LAN){

            JSONObject chunaglanReturnData = JSONObject.parseObject(smsRetCode);

            if(chunaglanReturnData != null){
                
                ChuangLanSmsCommitEntity smsCommitEntity = new ChuangLanSmsCommitEntity();
                if (StringUtils.equals("0",chunaglanReturnData.getString("code"))) {
                    // 表示发送正常 msgId 从返回数据里取出来
                    String msgId = chunaglanReturnData.getString("msgId");
                    orderSmsEntity.setMsgId(msgId);
                    smsCommitEntity.setMsgId(msgId);

                } else {
                    // 发送错误 msgid 自己生成一个
                    String msgId =  Long.valueOf(System.currentTimeMillis())
                            + sequenceNoBuilder.getSequenceValue(SeqBizTypeEnum.SMS);
                    orderSmsEntity.setMsgId(msgId);
                    smsCommitEntity.setMsgId(msgId);
                    orderSmsEntity.setSendStatus(OrderSmsSendStatusEnum.FAIL.getNum()); // 标记为发送失败的状态
                }

                // 创蓝的还要保存在另一张表
                smsCommitEntity.setOrderId(orderId);
                smsCommitEntity.setHandlerStatus(0);
                chuangLanSmsCommitMapper.insert(smsCommitEntity);

            }

        } else {
            // 非创蓝的直接保存结果
            orderSmsEntity.setSyncResult(smsRetCode);
        }

        baiqiOrderSmsMapper.insertOrderSms(orderSmsEntity);
    }
}
