package com.qiho.center.biz.service.impl.reply;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.reply.UserReplyDto;
import com.qiho.center.biz.service.reply.UserReplyService;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.daoh.qiho.reply.BaiqiUserReplyMapper;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.reply.BaiqiUserReplyEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author chensong
 * @create 2018-05-31 11:37
 **/
@Service
public class UserReplyServiceImpl implements UserReplyService {

    @Autowired
    private BaiqiUserReplyMapper baiqiUserReplyMapper;

    @Autowired
    private QihoOrderDAO qihoOrderDAO;

    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Override
    public ResultDto<Boolean> saveUserReply(UserReplyDto userReplyDto) {

        // 回复内容
        String content = userReplyDto.getContent();
        // 手机号
        String mobile = userReplyDto.getMobile();
        if (StringUtils.isBlank(content) || StringUtils.isBlank(mobile)) {
            return ResultDto.failResult("数据错误，手机号或内容不能为空");
        }

        // 获取用户最新的一笔正式订单
        QihoOrderSnapshotEntity order = qihoOrderSnapshotDAO.getLastByMobile(mobile);
        if (order == null) {
            return ResultDto.failResult("该手机号还没有正式的订单");
        }

        // 关联用户回复到这笔订单
        BaiqiUserReplyEntity userReplyEntity = new BaiqiUserReplyEntity();
        userReplyEntity.setOrderId(order.getOrderId());
        userReplyEntity.setContent(content);
        userReplyEntity.setMobile(mobile);
        baiqiUserReplyMapper.insertUserReply(userReplyEntity);

        return ResultDto.successResult(Boolean.TRUE);
    }

    @Override
    public List<UserReplyDto> getUserReplyByOrderId(String orderId) {
        List<BaiqiUserReplyEntity> userReplyEntities = baiqiUserReplyMapper.listUserReplyByOrderId(orderId);
        if (CollectionUtils.isEmpty(userReplyEntities)) {
            return Lists.newArrayList();
        }

        return BeanUtils.copyList(userReplyEntities, UserReplyDto.class);
    }


}
