package com.qiho.center.biz.service.logistics;

import com.qiho.center.common.entityd.qiho.logistics.BaiqiExpressCodeMappingEntity;

/**
 * 快递鸟服务
 * @author: wangjin
 * @create 2018-06-11 11:17
 **/
public interface ExpressBirdService {

    /**
     * 校验快递鸟签名
     * @param sign 签名
     * @param resData 请求数据
     * @return
     */
    boolean checkExpressSign(String sign,String resData);

    /**
     * 处理快递鸟推送过来的状态
     * @param code 快递公司编码
     * @param postId 快递单号
     * @param status 快递状态
     * @return
     */
    boolean dealExpressStatus(String code,String postId,String status);

    /**
     * 查询百奇快递对应的快递鸟
     * @param logisticsCode
     * @param expressPlatform
     * @return
     */
    BaiqiExpressCodeMappingEntity findByBaiqiLogisticsCode(String logisticsCode, String expressPlatform);
}
