package com.qiho.center.biz.service.logistics;

import cn.com.duiba.boot.exception.BizException;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.dto.logistics.LogisticsNicknameDto;
import com.qiho.center.api.params.logitics.LogisticsQueryParam;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;

import java.util.List;

/**
 * 物流服务相关接口
 *
 * @author chensong
 * @create 2017-12-28 16:37
 **/
public interface LogisticsService {

    /**
     * 分页查询物流公司信息
     *
     * @param param
     *
     * @return
     */
    PagenationDto<LogisticsDto> queryPage(LogisticsQueryParam param);

    /**
     * 获取物流公司的别称
     *
     * @param logisticsId 物流公司的id
     *
     * @return
     */
    List<LogisticsNicknameDto> findNickname(Long logisticsId);

    /**
     * 获取所有物流公司列表
     *
     * @return 集合
     */
    List<BaiqiLogisticsEntity> findAll();

    /**
     * 新增物流公司别称
     *
     * @param dto
     *
     * @return
     */
    Boolean addNickname(LogisticsNicknameDto dto) throws BizException;

    /**
     * 删除物流公司别称
     *
     * @param nicknameId
     *
     * @return
     */
    Boolean deleteNickname(Long nicknameId) throws BizException;

    /**
     * 获取缓存中所有物流公司列表
     *
     * @return 集合
     */
    List<BaiqiLogisticsEntity> findAllByCache();

    /**
     * 根据code获取物流公司信息
     *
     * @param logisticsCode code
     *
     * @return 信息
     */
    BaiqiLogisticsEntity findByCode(String logisticsCode);

    /**
     * 根据主键ID查询信息
     *
     * @param id 主键ID
     *
     * @return 信息
     */
    BaiqiLogisticsEntity findById(Long id);

    /**
     * 新增物流公司
     *
     * @param dto
     *
     * @return
     */
    Boolean insertLogistics(LogisticsDto dto);

    /**
     * 删除物流公司
     *
     * @param id
     *
     * @return
     */
    Boolean deleteLogistics(Long id);

}
