package com.qiho.center.biz.service.menu;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.menu.MenuDto;
import com.qiho.center.api.params.menu.MenuParams;

import java.util.List;

/**
 * 菜单接口
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 16:21
 */
public interface MenuService {

    /**
     * 初始化
     *
     * @return
     */
    boolean initMenu();

    /**
     * 保存菜单
     *
     * @param menuDto
     * @return
     */
    Long saveMenu(MenuDto menuDto) throws BizException;

    /**
     * 修改菜单
     *
     * @param menuDto
     * @return
     */
    Integer updateMenu(MenuDto menuDto) throws BizException;

    /**
     * 修改菜单
     *
     * @param menuDto
     * @return
     */
    Integer updateByCode(MenuDto menuDto) throws BizException;

    /**
     * ID 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id) throws BizException;

    /**
     * code 删除
     *
     * @param code
     * @return
     */
    Integer deleteByCode(String code) throws BizException;

    /**
     * 根据Code 查询
     *
     * @param code
     * @return
     * @throws BizException
     */
    MenuDto findByCode(String code) throws BizException;

    /**
     * 查询菜单
     *
     * @param menuParams
     * @return
     * @throws BizException
     */
    List<MenuDto> findByParam(MenuParams menuParams) throws BizException;

}
