package com.qiho.center.biz.service.merchant.impl;

import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantUndeliveryDto;
import com.qiho.center.api.params.merchant.MerchantUndeliveryQueryParams;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.biz.service.merchant.MerchantUndeliveryService;
import com.qiho.center.common.daoh.qiho.merchant.MerchantUndeliveryMapper;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantUndeliveryEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 商家不配送区域服务
 *
 * @author peanut.huang
 * @date 2018/1/10.
 */
@Service
public class MerchantUndeliveryServiceImpl implements MerchantUndeliveryService {

    @Resource
    private MerchantUndeliveryMapper merchantUndeliveryMapper;
    @Resource
    private MerchantService merchantService;

    @Override
    public List<MerchantUndeliveryDto> findByParams(MerchantUndeliveryQueryParams queryParams) {

        Assert.notNull(queryParams, "查询参数为空");

        List<MerchantUndeliveryDto> dtoList =  merchantUndeliveryMapper.findByParams(queryParams);
        if(CollectionUtils.isNotEmpty(dtoList)){

            //add merchant name
            addMerchantName(dtoList);
        }
        return dtoList;
    }

    /**
     * add merchant name
     *
     * @param dtoList
     */
    private void addMerchantName(List<MerchantUndeliveryDto> dtoList) {

        //merchantIdList
        List<Long> merchantIdList = dtoList.stream()
                                           .map(MerchantUndeliveryDto::getMerchantId)
                                           .distinct()
                                           .collect(Collectors.toList());

        //find id and name list
        List<MerchantSimpleDto> simpleDtoList = merchantService.findIdAndNamesByIds(merchantIdList);

        if(CollectionUtils.isEmpty(simpleDtoList)){
            return;
        }

        //list to map
        Map<Long, String> idAndNameMap = simpleDtoList.stream().collect(Collectors.toMap(
                                                                                        MerchantSimpleDto :: getId,
                                                                                        MerchantSimpleDto::getMerchantName,
                                                                                        (oldOne, newOne) -> newOne,
                                                                                        HashMap:: new)
                                                                                        );
        // foreach set name
        dtoList.forEach(dto -> dto.setMerchantName(idAndNameMap.get(dto.getMerchantId())));
    }

    @Override
    public int countByParams(MerchantUndeliveryQueryParams queryParams) {

        Assert.notNull(queryParams, "查询参数为空");

        return merchantUndeliveryMapper.countByParams(queryParams);
    }

    @Override
    public Boolean deleteByIds(List<Long> idList) {
        return !CollectionUtils.isEmpty(idList) && merchantUndeliveryMapper.deleteByIds(idList) > 0;

    }

    @Override
    public Boolean batchInsert(List<BaiqiMerchantUndeliveryEntity> undeliveryList) {
        return !CollectionUtils.isEmpty(undeliveryList) && merchantUndeliveryMapper.batchInsert(undeliveryList) > 0;

    }

    @Override
    public List<String> findUndelivery(Long merchantId) {
        if(merchantId == null){
            return Collections.emptyList();
        }
        return merchantUndeliveryMapper.findUndelivery(merchantId);
    }
}
