package com.qiho.center.biz.service.monitor;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorPlanDto;
import com.qiho.center.api.params.MonitorPlanQueryParam;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorPlanEntity;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorStrategyEntity;

import java.util.List;

/**
 * Created by qianjue on 2017/10/31.
 */
public interface LogisticsMonitorPlanService {

	/**
	 * 新增和修改监控计划和策略详情
	 * @param dto
	 * @return
	 */
	int saveLogistMonitorPlan(LogisticsMonitorPlanDto  dto);

	/**
	 * 根据ID查询监控计划和详情
	 * @param id
	 * @return
	 */
	LogisticsMonitorPlanDto  getLogisticsMonitorPlanById(Long  id);

	/**
	 * 删除监控计划
	 * @param id
	 * @return
	 */
	int deleteMonitorPlan(Long  id);

	/**
	 * 分页查询
	 * @param queryParam
	 * @return
	 */
	PagenationDto<LogisticsMonitorPlanDto> queryPageList(MonitorPlanQueryParam queryParam);

	/**
	 * 查询当前时间优先级最高的监控计划
	 * @return
	 */
	LogisticsMonitorPlanEntity  queryValidMonitorPlan(String logisticsCode);

	/**
	 * 根据计划ID查询策略详情列表
	 * @return
	 */
	List<LogisticsMonitorStrategyEntity> selectStrategyListByPlanId(Long planId);

	/**
	 * 更新
	 * @param strategyEntity
	 * @return
	 */
	int  updateStrategyExecuteTime(LogisticsMonitorStrategyEntity strategyEntity);
}
