package com.qiho.center.biz.service.order;

import com.qiho.center.api.dto.AfterSaleOrderDto;
import com.qiho.center.api.params.AfterSaleQueryParams;

import java.util.List;

/**
 * Created by chensong on 2017/10/11 0011.
 */
public interface AfterSaleOrderService {

    /**
     * 根据OrderId获取最新一笔售后子订单
     * @param orderId
     * @return
     */
    List<AfterSaleOrderDto> findByOrderId(String orderId);

    Boolean updateAfterSaleOrder(AfterSaleOrderDto dto);

    Boolean updateAfterSaleMetaValue(AfterSaleOrderDto dto);

    /**
     * 是否打开售后详情入口
     * @param orderId
     * @return
     */
    Boolean openAfterSale(String orderId);

    /**
     * 是否可以发起售后
     * @param orderId
     * @return
     */
    Boolean sponsorAfterSale(String orderId);

    /**
     * 获取订单的所有售后子订单
     * @param orderId
     * @return
     */
    List<AfterSaleOrderDto> findAll(String orderId);

    /**
     * 通过条件分页查询,默认日期区间最近30天
     */
    List<AfterSaleOrderDto> findAfterSaleByQuery(AfterSaleQueryParams params);

    /**
     * 通过条件分页查询总数
     */
    Integer countAfterSaleByQuery(AfterSaleQueryParams params);

    /**
     * 新增售后子订单
     */
    String save(AfterSaleOrderDto dto);

    /**
     * 根据售后子订单id查询售后子订单
     */
    AfterSaleOrderDto queryAfterSaleById(String afterSaleId);

    /**
     * 根据售后子订单id批量查询
     */
    List<AfterSaleOrderDto> queryAfterSaleByIds(List<String> afterSaleIds);

    /**
     * 更新物流信息
     * @param afterSaleOrderDto
     * @return
     */
    Boolean updateLogistics(AfterSaleOrderDto afterSaleOrderDto);

}
