/**
 * Project Name:qiho-center-biz
 * File Name:AnticheateService.java
 * Package Name:com.qiho.center.biz.service.order
 * Date:2017年6月6日下午1:42:26
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import com.qiho.center.api.dto.AnticheateDto;
import com.qiho.center.common.entity.order.QihoAnticheateEntity;

import java.util.List;

/**
 * ClassName:AnticheateService <br/>
 * 防作弊服务. <br/>
 * Date:     2017年6月6日 下午1:42:26 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface AnticheateService {

    /**
     * 根据订单ID查询防作弊命中规则
     * @author zhanglihui
     * @param orderId
     * @return AnticheateDto
     */
    AnticheateDto findByOrderId(String orderId);

    /**
     * 新增一条命中规则记录
     * @param qihoAnticheateEntity
     * @return
     */
    void insert(QihoAnticheateEntity qihoAnticheateEntity);

    /**
     * 批量查询防作弊信息
     */
    List<AnticheateDto> findByOrderIds(List<String> orderIds);


}

