/**
 * Project Name:qiho-center-biz
 * File Name:OrderService.java
 * Package Name:com.qiho.center.biz.service
 * Date:2017年6月2日下午7:20:31
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.biz.service.order;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.order.*;
import com.qiho.center.api.dto.task.BatchOrderTaskDto;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;

import java.util.Date;
import java.util.List;

/**
 * ClassName:OrderService <br/>
 * 订单服务. <br/>
 * Date:     2017年6月2日 下午7:20:31 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface OrderService {

    /**
     * 创建订单
     * @author zhanglihui
     * @param order       订单内容
     * @param channelInfo 订单渠道信息
     * @param payType     付款方式
     * @return 订单ID
     */
    @Deprecated
    String createOrder(OrderDto order, ChannelInfoDto channelInfo, String payType);


    /**
     * 创建订单
     * 数据来源于临时订单
     * @param order
     * @param channelInfo
     * @param payType
     */
    void createOrderFromTmp(OrderDto order, ChannelInfoDto channelInfo, String payType);




    /**
     * 审核订单
     * @param params
     */
    Boolean auditOrder(OrderAuditParams params);

    /**
     * 根据订单ID查询订单信息
     * @author zhanglihui
     * @param orderId
     * @return OrderDto
     */
    OrderDto findByOrderId(String orderId);

    /**
     * 更新订单商品信息
     * @author zhanglihui
     * @param param
     */
    void updateOrderItem(OrderItemParam param);

    /**
     * 更新订单商品信息_不校验限购数量
     * @author zhanglihui
     * @param param
     */
    void updateOrderItemInfo(OrderItemParam param);

    /**
     * 更新订单买家信息
     * @author zhanglihui
     * @param param
     */
    void updateOrderConsumer(OrderConsumerParam param);

    /**
     * 更新订单买家信息_不校验地址
     * @author jiafeng.geng
     * @param param
     */
    void updateOrderConsumerInfo(OrderConsumerParam param);

    /**
     * 将订单变成失败
     * @param orderId
     * @param remark
     * @param orderApprovalStatusEnum 审核状态
     */
    void rejectOrder(String orderId, String remark, OrderApprovalStatusEnum orderApprovalStatusEnum);

    /**
     * 更新主订单状态
     * @param orderId
     * @param orderStatus
     */
    void updateOrderStatus(String orderId, OrderStatusEnum orderStatus);

    /**
     * 根据orderId更新主订单信息
     *
     * @param orderDto
     */
    void updateByOrderId(OrderDto orderDto);
    

    boolean  closeOrder(String orderId,String remark,String fundId);


    ItemDetailDto getOrderItemSnapshot(String orderId, Long itemId);

	/**
	 * 物流监控查询统计sql专用
     * @return
     */
    Long  queryMonitorOrderCount(String orderStatus,Date  startTime,Date endTime,List<String> provinceList);

    /**
     * 获取用户最新的一笔成功订单
     * @param mobile
     * @return
     */
    OrderDto getLastOrderByMobile(String mobile);


    /**
     * 根据推啊的acid 获取最新的一笔的正式订单
     * @param acid
     * @return
     */
    OrderDto getLastOrderByAcid(String acid);

    /**
     * 单个主订单
     * 确认发货
     * @param orderConfirmDto
     */
    Boolean orderConfirm(OrderConfirmDto orderConfirmDto) throws BizException;


    /**
     * 单个取消
     * 主订单发货
     * 关闭订单
     * @param orderId 订单编号
     * @param remark  订单备注
     * @return
     */
    Boolean orderCancel(String orderId, String remark) throws BizException;

    /**
     *
     * @return
     * @param
     */
    Boolean orderUpdate(OrderConfirmDto orderConfirmDto) throws BizException;

    /**
     * 批量处理
     * 主订单确认发货
     * @param batchOrderConfirmDto
     * @return
     */
    BatchOrderTaskDto batchOrderConfirm(BatchOrderConfirmDto batchOrderConfirmDto);

    /**
     * 批量更新
     * @param batchOrderConfirmDto
     * @return
     */
    BatchOrderTaskDto batchOrderUpdate(BatchOrderConfirmDto batchOrderConfirmDto);

    /**
     * 批量取消
     * @param batchOrderCancelDto
     */
    BatchOrderTaskDto batchOrderCancel(BatchOrderCancelDto batchOrderCancelDto);


    /**
     * 对外商家批量处理
     * 主订单确认发货
     * @param confirmDto
     * @return
     */
    BatchOrderTaskDto openBatchOrderConfirm(OpenBatchOrderConfirmDto confirmDto);

    /**
     * 对外商家批量处理
     * 订单取消发货
     * @param cancelDto
     * @return
     */
    BatchOrderTaskDto openBatchOrderCancel(OpenBatchOrderCancelDto cancelDto);

}

