package com.qiho.center.biz.service.order;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderGainParams;
import com.qiho.center.api.params.OrderPageParams;
import com.qiho.center.biz.event.OrderCreateFromTmpEvent;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 2017/6/3.
 */
public interface OrderSnapshotService {

    public PagenationDto<OrderSnapshotDto> findOrderPage(OrderPageParams params);

    public List<OrderSnapshotDto> findOrderPageForExport(OrderPageParams params);

    public Integer findAllPageCount(OrderPageParams params);

    /**
     * 根据订单ID查询订单快照
     *
     * @param orderId
     *
     * @return OrderSnapshotDto
     *
     * @author zhanglihui
     */
    public OrderSnapshotDto findByOrderId(String orderId);

    /**
     * 查询导出订单总数(远远大于真实总数)
     *
     * @param params
     *
     * @return
     */
    public Integer exportOrderPageCount(OrderPageParams params);

    /**
     * 更新
     *
     * @param orderId
     * @param remark                  备注
     * @param orderStatus             订单状态
     * @param orderApprovalStatusEnum 审批状态
     *
     * @return
     */
    public Integer updateOrderStatus(String orderId, String remark, OrderStatusEnum orderStatus,
        OrderApprovalStatusEnum orderApprovalStatusEnum);

    /***
     * 正式订单创建的后续处理
     * @param orderCreateEvent
     */
    void createOrderFromTmpListener(OrderCreateFromTmpEvent orderCreateEvent);

    /**
     * 根据手机号查询订单列表
     *
     * @param mobile     手机号
     * @param statusList 订单状态
     *
     * @return List<OrderSnapshotDto>
     *
     * @author zhanglihui
     */
    public List<OrderSnapshotDto> findByMobile(String mobile, List<String> statusList);

    /**
     * 根据商品ID查询商品的在一段时间内的销售总量
     *
     * @param itemId
     *
     * @return
     */
    public Integer queryItemSaleCount(Long itemId, Date startTime, Date endTime);

    /**
     * 根据订单id更新订单处理方式字段及短信处理时间
     * ps:只有当处理方式流转为短信捞单的时候,才记录处理时间
     */
    Integer updateOrderProcessWayByOrderId(OrderGainParams orderGainParams);

    /**
     * 批量查询订单快照信息
     */
    List<OrderSnapshotDto> queryOrderByOrderIds(List<String> orderIds);

    OrderSnapshotDto queryByMobileAsNewMost(String mobile, String orderStatus);

    Map<Long, Integer> queryItemSaleCountBatch(List<Long> itemId, Date startTime, Date endTime);

    List<OrderSnapshotDto> queryOrderAsNewMost(OrderPageParams pageParams);

    /**
     * 订单数据加工用于导出数据
     */
    List<OrderSnapshotDto> getHandlerOrderSnapshotDto(List<QihoOrderSnapshotEntity> list);

    /**
     * 根据手机号和商品ID查询
     *
     * @param mobile 手机号
     * @param itemId 商品ID
     *
     * @return 集合
     */
    List<QihoOrderSnapshotEntity> findByMobileAndItem(String mobile, Long itemId);

    /**
     * 根据订单id和手机号查询
     * @param orderId
     * @param mobile
     * @return
     */
    OrderSnapshotDto findByOderIdAndMobile(String orderId, String mobile);

    /**
     * 根据orderId更新订单信息
     *
     * @param orderSnapshotDto
     */
    void updateByOrderId(OrderSnapshotDto orderSnapshotDto);

}
