/**
 * Project Name:qiho-center-biz
 * File Name:SmsService.java
 * Package Name:com.qiho.center.biz.service.order
 * Date:2017年6月3日下午12:02:19
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.service.order;

import java.util.Map;

import com.qiho.center.api.params.YunPianPushParams;
import com.qiho.center.common.entity.QihoTemplateEntity;

/**
 * ClassName:SmsService <br/>
 * 短信服务. <br/>
 * Date:     2017年6月3日 下午12:02:19 <br/>
 *
 * @author zhanglihui
 * @see
 * @since JDK 1.6
 */
public interface SmsService {

    /**
     * 发送短信验证码，用于下单校验
     *
     * @param mobile  手机号码
     * @param smsCode 验证码
     *
     * @return 是否发送成功
     *
     * @author zhanglihui
     */
    boolean sendSmsCode(String mobile, String smsCode);

    /**
     * 发送短信
     * 需要参数渲染
     *
     * @param entity 短信模板
     * @param entity 替换变量map
     * @param mobile 手机号码
     *
     * @return 是否发送成功
     */
    boolean singleSend(QihoTemplateEntity entity, Map<String, String> context, String mobile);

    /**
     * 发送短信
     * 需要参数渲染
     *
     * @param entity 短信模板
     * @param entity 替换变量map
     * @param mobile 手机号码
     *
     * @return 是否发送成功
     */
    String singleSendRetCode(QihoTemplateEntity entity, Map<String, String> context, String mobile);

    /**
     * 发送短信
     * PS:不需要变量渲染
     *
     * @param entity 短信模板
     * @param mobile 手机号码
     *
     * @return 是否发送成功
     */
    boolean singleSend(QihoTemplateEntity entity, String mobile);

    /**
     * 验证云片签名正确性:ture为验签通过
     */
    boolean checkSign(YunPianPushParams params);
}

