package com.qiho.center.biz.service.orderexport;

import com.qiho.center.api.dto.orderexport.FieldDto;
import com.qiho.center.api.dto.orderexport.TemplateFieldDto;

import java.util.List;

/**
 * 订单导出模板字段service
 *
 * @author peanut.huang
 * @date 2017/11/27.
 */
public interface OrderExportTemplateFieldService {

    /**
     * 根据模板id获取模板字段
     *
     * @param tempId  模板id
     * @return
     */
    List<TemplateFieldDto> findByTempId(Long tempId);

    /**
     * 保存模板字段
     *
     * @param templateFieldDto
     * @return
     */
    Boolean saveTempField(TemplateFieldDto templateFieldDto);

    /**
     * 字段下拉列表
     *
     * @return
     */
    List<FieldDto> findField4Select();

    /**
     * 根据id查询
     *
     * @param tempFieldId  模板字段主键关联id
     * @return
     */
    TemplateFieldDto findById(Long tempFieldId);

    /**
     * 删除模板字段
     *
     * @param tempFieldId   模板字段关联主键id
     * @return
     */
    Boolean deleteById(Long tempFieldId);
}
