package com.qiho.center.biz.service.orderexport;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.orderexport.OrderExportTemplateDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;

import java.util.List;

/**
 * 订单导出模板
 *
 * @author peanut.huang
 * @date 2017/11/27.
 */
public interface OrderExportTemplateService {

    /**
     * 模板分页查询
     *
     * @param templateQueryParams
     * @return
     */
    PagenationDto<OrderExportTemplateDto> find4Page(OrderExportTemplateQueryParams templateQueryParams);

    /**
     * 保存模板
     *
     * @param id        模板id
     * @param tempName  模板名称
     * @return
     */
    Boolean save(Long id, String tempName);

    /**
     * 根据模板id删除模板
     *
     * <p> a、删除模板本身 </p>
     *
     * <p> b、删除模板与字段道经 </p>
     *
     * @param id  模板id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 下拉所有模板
     *
     *  只有模板id与名称字段
     *
     * @return
     */
    List<OrderExportTemplateDto> findTemp4Select();
}
