package com.qiho.center.biz.service.page;

import com.qiho.center.api.dto.page.CollItemDto;
import com.qiho.center.api.dto.page.CollItemSaveDto;
import com.qiho.center.api.enums.page.CollItemStatusEnum;

import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-07-24.
 */
public interface CollItemService {

    /**
     * 查询集合页商品列表
     *
     * @param collId 集合页id
     * @return List<CollItemDTO>
     */
    List<CollItemDto> queryItemListBySort(Long collId);

    /**
     * 根据集合页id和商品id集合查询集合页商品列表
     *
     * @param collId      集合页id
     * @param collItemIds 集合页商品id集合
     * @return List<CollItemDTO>
     */
    List<CollItemDto> queryItemListBySortWithItemIds(Long collId, List<Long> collItemIds);

    /**
     * 新增集合页商品列表
     *
     * @param collItemSaveDtoList
     * @return Integer
     */
    Integer addCollItemList(List<CollItemSaveDto> collItemSaveDtoList);

    /**
     * 更新集合页商品列表
     *
     * @param collItemSaveDtoList
     * @return Integer
     */
    Integer updateCollItemList(List<CollItemSaveDto> collItemSaveDtoList);

    /**
     * 查询最大排序值
     *
     * @param collId 集合页id
     * @return Integer
     */
    Integer findMaxSort(Long collId);

    /**
     * 物理删除集合页商品
     *
     * @param collId 集合页id
     * @param itemId 商品id
     * @return Integer
     */
    Integer deleted4Phy(Long collId, Long itemId);

    /**
     * 批量删除所有集合页中的商品
     *
     * @param itemIds
     * @return Integer
     */
    Integer batchDeleted(List<Long> itemIds);

    /**
     * 排序集合页商品
     *
     * @param collId  集合页id
     * @param itemIds 商品id集合
     * @return Integer
     */
    Integer sort(Long collId, List<Long> itemIds);

    /**
     * 批量启用/禁用集合页商品
     *
     * @param collId         集合页id
     * @param itemIds        商品id集合
     * @param collItemStatus 更新后的商品状态, {@link CollItemStatusEnum}
     * @return Integer
     */
    Integer updateStatusBatch(Long collId, List<Long> itemIds, Integer collItemStatus);

    /**
     * 查询集合页商品
     *
     * @param collId 集合页id
     * @param itemId 商品id
     * @return CollItemDTO
     */
    CollItemDto queryItem(Long collId, Long itemId);
}
