package com.qiho.center.biz.service.page.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.dto.page.PageComponentDetailDto;
import com.qiho.center.api.dto.page.PageComponentDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;
import com.qiho.center.biz.service.page.BaiqiPageService;
import com.qiho.center.biz.service.page.PageComponentService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.component.BaiqiComponentMapper;
import com.qiho.center.common.daoh.qiho.page.BaiqiPageComponentMapper;
import com.qiho.center.common.entityd.qiho.component.BaiqiComponentEntity;
import com.qiho.center.common.entityd.qiho.page.BaiqiPageComponentEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2018-08-01
 */
@Service
public class PageComponentServiceImpl implements PageComponentService {

    @Autowired
    private BaiqiPageComponentMapper baiqiPageComponentMapper;

    @Autowired
    private BaiqiPageService baiqiPageService;

    @Autowired
    private BaiqiComponentMapper baiqiComponentMapper;

    @Override
    @Transactional(value = DsConstants.DATABASE_QIHO,rollbackFor = Exception.class)
    public ResultDto<Boolean> savePageComponent(BaiqiPageDto pageDto, List<PageComponentDto> pageComponentList) {

        // insert or update tb_baiqi_page
        Long pageId = baiqiPageService.savePage(pageDto);
        if (pageId == null) {
            return ResultDto.failResult("更新页面失败");
        }

        if (pageDto.getId() == null) {
            // insert tb_page_component
            insertPageComponent(pageId, pageComponentList);

        } else {
            // update tb_page_component
            updatePageComponent(pageId, pageComponentList);
        }

        return ResultDto.successResult();
    }

    @Override
    public PageComponentDetailDto findPageComponentById(Long pageId) {

        // 查询组件信息
        BaiqiPageDto baiqiPageDto = baiqiPageService.findById(pageId);
        if (baiqiPageDto == null) {
            return null;
        }

        PageComponentDetailDto page = BeanUtils.copy(baiqiPageDto, PageComponentDetailDto.class);

        // 查询页面组件关联信息
        List<BaiqiPageComponentEntity> pageComponentEntities = baiqiPageComponentMapper.findByPageId(pageId);
        if (CollectionUtils.isEmpty(pageComponentEntities)) {
            page.setComponentList(Lists.newArrayList());
            return page;
        }


        List<Long> componentIdList = pageComponentEntities.parallelStream()
                                    .map(BaiqiPageComponentEntity::getComponentId).collect(Collectors.toList());
        // 查一次组件表
        List<BaiqiComponentEntity> componentEntityList = baiqiComponentMapper.listByIds(componentIdList);
        Map<Long, BaiqiComponentEntity> componentEntityMap = componentEntityList.stream()
                .collect(Collectors.toMap(BaiqiComponentEntity::getId, Function.identity()));

        //  数据类型转换
        List<PageComponentDto> componentList = pageComponentEntities.stream().map(e->{
            PageComponentDto dto = BeanUtils.copy(e, PageComponentDto.class);
            BaiqiComponentEntity componentEntity = componentEntityMap.get(e.getComponentId());
            dto.setImage(componentEntity == null ? "" : componentEntity.getImage());
            dto.setComponentName(componentEntity == null ? "" : componentEntity.getComponentName());
            componentIdList.add(e.getComponentId());
            dto.setComponentType(ComponentTypeEnum.getByNum(e.getComponentType()));
            return dto;
        }).collect(Collectors.toList());
        page.setComponentList(componentList);

        return page;
    }

    /**
     * insert tb_page_component 数据
     * @param pageId
     * @param pageComponentList
     */
    private void insertPageComponent(Long pageId, List<PageComponentDto> pageComponentList){
        List<BaiqiPageComponentEntity> list = pageComponentList.stream().map(e -> {
            BaiqiPageComponentEntity entity = BeanUtils.copy(e, BaiqiPageComponentEntity.class);
            entity.setPageId(pageId);
            entity.setComponentType(e.getComponentType().getNum());
            return entity;
        }).collect(Collectors.toList());
        baiqiPageComponentMapper.insertBatch(list);
    }

    /**
     * 先根据pageId删除数据 再insert
     * @param pageId
     * @param pageComponentList
     */
    private void updatePageComponent(Long pageId, List<PageComponentDto> pageComponentList){
        baiqiPageComponentMapper.deleteByPageId(pageId);
        List<BaiqiPageComponentEntity> list = pageComponentList.stream().map(e -> {
            BaiqiPageComponentEntity entity = BeanUtils.copy(e, BaiqiPageComponentEntity.class);
            entity.setPageId(pageId);
            entity.setComponentType(e.getComponentType().getNum());
            return entity;
        }).collect(Collectors.toList());
        baiqiPageComponentMapper.insertBatch(list);
    }



}
