package com.qiho.center.biz.service.region;

import com.qiho.center.api.dto.region.BaiqiRegionRelationDto;
import com.qiho.center.common.entityd.qiho.region.BaiqiRegionEntity;

import java.util.List;

/**
 * 中国省市区乡镇service
 * Author: zhanghuifeng
 * Date:   2018/1/16 10:07
 */
public interface BaiqiRegionService {

    /**
     * 根据上级区域ID查询所有区域
     * @param parentId 上级区域ID
     * @return 集合
     */
    List<BaiqiRegionEntity> find(Long parentId);

    /**
     * 修复区域编码
     * @param startId
     * @param endId
     * @return
     */
    int updateAreaNum(int startId, int endId);

    /**
     * 更新区域编码
     * @param regionName
     * @param areaNum
     * @return
     */
    int updateAreaNumByRegionName(String regionName, int areaNum);

    /**
     * 获取行政区划代码为空的区域信息，限制1000条
     * @param regionLevel
     * @return
     */
    List<BaiqiRegionEntity> findNullAreaNumRegion(Integer regionLevel);

    /**
     * 根据区域代码获取区域信息
     * @param areaNum
     * @return
     */
    BaiqiRegionRelationDto findRegionByAreaNum(Integer areaNum);

    /**
     * 根据名称和等级查询区域信息
     *
     * @param regionName  区域名称
     * @param regionLevel 区域等级
     * @return 区域信息
     */
    BaiqiRegionEntity findByNameAndLevel(String regionName, int regionLevel);
}
