package com.qiho.center.biz.service.tag;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;

import java.util.List;

/** 标签相关服务接口
 * @author chensong
 * @create 2018-03-21 16:48
 **/
public interface TagService {

    /**
     * 新增或修改标签
     * @param tagDto
     * @return
     */
    ResultDto<Boolean> saveTag(TagDto tagDto);

    /**
     * 删除标签
     * @param tagId
     * @return
     */
    Boolean delete(Long tagId);

    /**
     * 根据标签类型id获取标签
     * @param typeId
     * @return
     */
    List<TagDto> findByTypeId(Long typeId);

    /**
     * 分页查询标签
     * @param param
     * @return
     */
    PagenationDto<TagDto> queryPage(TagPageParam param);



}
