package com.qiho.center.biz.service.user.impl;

import java.util.List;

import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiMainAndAgenAccountDto;
import com.qiho.center.api.dto.user.UserEvaluateDto;
import com.qiho.center.api.params.user.UserEvaluatePagingParams;
import com.qiho.center.biz.service.user.UserEvaluateService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.merchant.MerchantUndeliveryMapper;
import com.qiho.center.common.daoh.qiho.user.UserEvaluateMapper;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.user.UserEvaluateEntity;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author: wangjin
 * @create 2018-05-23 15:06
 **/
@Service
public class UserEvaluateServiceImpl implements UserEvaluateService {

    @Resource
    private UserEvaluateMapper userEvaluateMapper;
    @Resource
    private QihoMerchantDAO merchantDAO;

    @Override
    public int insert(UserEvaluateDto record) {
        QihoMerchantEntity entity = merchantDAO.getById(record.getMerchantId());
        record.setMerchantName(entity.getMerchantName());
        return userEvaluateMapper.insert(BeanUtils.copy(record,UserEvaluateEntity.class));
    }

    @Override
    public int selectUserEvaluateCount(String orderId) {
        return userEvaluateMapper.selectUserEvaluateCount(orderId);
    }

    @Override
    public UserEvaluateDto selectLatestUserEvaluate(String orderId) {
        return BeanUtils.copy(userEvaluateMapper.selectLatestUserEvaluate(orderId),UserEvaluateDto.class);
    }

    @Override
    public PagenationDto<UserEvaluateDto> findPaging(UserEvaluatePagingParams pagingParams) {

        PagenationDto<UserEvaluateDto> pagenationDto = new PagenationDto<>();

        // 查询分页列表数据
        List<UserEvaluateEntity> pagingList = userEvaluateMapper.findPagingList(pagingParams);
        if(CollectionUtils.isEmpty(pagingList)){
            return pagenationDto.emptyPage();
        }

        // 查询分页总数
        int count = userEvaluateMapper.findPagingCount(pagingParams);

        pagenationDto.setTotal(count);
        pagenationDto.setList(BeanUtils.copyList(pagingList, UserEvaluateDto.class));

        return pagenationDto;
    }

    @Override
    public List<UserEvaluateDto> findEvaluateList(UserEvaluatePagingParams pagingParams) {
        List<UserEvaluateEntity> pagingList = userEvaluateMapper.findPagingList(pagingParams);
        return BeanUtils.copyList(pagingList, UserEvaluateDto.class);
    }
}
