package com.qiho.center.biz.service.user.impl;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.qiho.center.api.dto.user.WechatUserDto;
import com.qiho.center.biz.service.user.WechatUserService;
import com.qiho.center.common.daoh.qiho.user.WechatUserMapper;
import com.qiho.center.common.entityd.qiho.user.WechatUserEntity;

import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * @author peanut.huang
 * @date 2018/1/26.
 */
@Service
public class WechatUserServiceImpl implements WechatUserService {

    @Resource
    private WechatUserMapper wechatUserMapper;

    @Override
    public Boolean insertUser(WechatUserEntity wechatUserEntity) {
        if(wechatUserEntity == null){
            throw new IllegalArgumentException("微信用户实体为空");
        }

        // check miniOpenId
        String miniOpenId = wechatUserEntity.getMiniOpenId();
        if(StringUtils.isBlank(miniOpenId)){
            throw new IllegalArgumentException("小程序openId为空");
        }

        return wechatUserMapper.insert(wechatUserEntity) > 0;
    }

    @Override
    public Long findUserIdByMiniOpenId(String miniOpenId) {
        if(StringUtils.isBlank(miniOpenId)){
            return null;
        }

        return wechatUserMapper.findUserIdByMiniOpenId(miniOpenId);
    }

    @Override
    public WechatUserDto findUserIdByMiniUnionId(String unionId) {
        return BeanUtils.copy(wechatUserMapper.findUserIdByMiniUnionId(unionId),WechatUserDto.class);
    }
}
