package com.qiho.center.biz.subscribe;

import com.google.common.eventbus.Subscribe;
import com.qiho.center.biz.bo.ExpressBo;
import com.qiho.center.biz.event.KuaiDi100Event;
import com.qiho.center.common.annotations.BizEventListener;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by weny.cai on 2018/3/21.
 */
@Service
@BizEventListener
public class KuaiDi100Subscribe {

    @Resource
    private ExpressBo expressBo;

    /**
     * 快递100异步事件
     * @author weny.cai
     * @param kuaiDi100Event
     */
    @Subscribe
    public void handle(KuaiDi100Event kuaiDi100Event){
        //发布快递异步事件
        expressBo.subscribeExpress(kuaiDi100Event.getLogisticsOrderDos());
    }


}
