package com.qiho.center.biz.task;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.task.bo.OrderConfirmDo;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by weny.cai on 2018/3/29.
 */
@Component
@Scope("prototype")
public class OrderConfirmBoRunnable extends OrderBoRunnable{

    private final Logger logger = LoggerFactory.getLogger(OrderConfirmBoRunnable.class);

    private static final String NUM_AND_LETTER_REG_EX = "^[A-Za-z0-9]{1,40}$";

    @Autowired
    SequenceNoBuilder builder;


    public OrderConfirmBoRunnable(BatchOrderTask batchOrderTask, CountDownLatch countDownLatch) {
        super(batchOrderTask, countDownLatch);
    }

    /**
     * 校验参数是否正确
     * @param confirmDo
     * @param orderSnapshotEntity
     * @return
     */
    @Override
    public boolean checkParam(OrderConfirmDo confirmDo, OrderSnapshotEntity orderSnapshotEntity) {
        this.detailEntity = new OrderConfirmTaskDetailEntity();
        detailEntity.setOrderId(confirmDo.getOrderId());
        detailEntity.setOrderConfirmTaskId(task.getTaskEntity().getId());
        detailEntity.setPostId(confirmDo.getPostId());
        detailEntity.setLineNum(confirmDo.getLineNum());

        if("ERROR_CELL".equals(confirmDo.getPostId())||"ERROR_CELL".equals(confirmDo.getOrderId())){
            detailEntity.setOrderId("");
            detailEntity.setFailMsg("错误的单元格");
            return false;
        }

        if(orderSnapshotEntity == null){
            detailEntity.setFailMsg("订单ID不存在!");
            return false;
        }

        if(orderSnapshotEntity.getDelivery().equals("ERP")){
            detailEntity.setFailMsg("ERP订单操作失败!");
            return false;
        }

        //订单必须处于待发货状态
        if(!(OrderStatusEnum.TO_SEND.getCode().equals(orderSnapshotEntity.getOrderStatus())
                ||OrderStatusEnum.TO_APPROVE.getCode().equals(orderSnapshotEntity.getOrderStatus()))){
            detailEntity.setFailMsg("订单非待发货或待审核状态!");
            return false;
        }


        //格式不完整 不处理 返回失败
        if (StringUtils.isBlank(confirmDo.getPostId()) || StringUtils.isBlank(confirmDo.getOrderId()) ) {
            detailEntity.setFailMsg("订单ID或物流单号为空!");
            return false;
        }


        // 验证物流信息
        if (StringUtils.isBlank(confirmDo.getLogisticsCode()) || StringUtils.isBlank(confirmDo.getLogisticsName())) {
            detailEntity.setFailMsg("物流编码有误!");
            return false;
        }

        // 忽略大小写的写法
        Pattern pat = Pattern.compile(NUM_AND_LETTER_REG_EX, Pattern.CASE_INSENSITIVE);
        Matcher matcher = pat.matcher(confirmDo.getPostId());
        // 字符串是否与正则表达式相匹配
        boolean rs = matcher.matches();
        if (!rs) {//数字和字母的检验
            detailEntity.setFailMsg("物流单号格式有误!");
            return false;
        }

        //-1奇货后台传的数据 不进行商家校验
        if(confirmDo.getMerchantId()==-1){
            return true;
        }

        //对商家进行校验 操作权限
        if (!confirmDo.getMerchantId().equals(orderSnapshotEntity.getMerchantId())) {
            detailEntity.setFailMsg("不属于导入的商家!");
            return false;
        }
        return true;
    }

    /**
     * 单笔进行审核操作
     * @param bo
     * @param orderSnapshotEntity
     */
    @Override
    public void auditOrder(OrderConfirmDo bo,OrderSnapshotEntity orderSnapshotEntity,QihoErpOrderEntity erpOrderEntity) {

        // 判断是否是待审核订单 且 erp订单不存在,满足条件订单从待审核到待发货
        if (OrderStatusEnum.TO_APPROVE.getCode().equals(orderSnapshotEntity.getOrderStatus())&&
                Objects.isNull(erpOrderEntity)){
            erpOrderEntity = auditOrderToSuccess(orderSnapshotEntity);
        }

        //初始化物流子订单参数
        LogisticsOrderEntity logisticsOrderEntity = new LogisticsOrderEntity();
        logisticsOrderEntity.setOrderId(bo.getOrderId());
        logisticsOrderEntity.setErpId(erpOrderEntity.getErpId());
        logisticsOrderEntity.setPostId(bo.getPostId());
        logisticsOrderEntity.setLogisticsCode(bo.getLogisticsCode());
        logisticsOrderEntity.setLogisticsName(bo.getLogisticsName());
        logisticsOrderEntity.setLogisticsStatus(YTOLogisticsStatusEnum.ACCEPT.getDesc());
        // 物流子订单初始化状态为接单
        logisticsOrderEntity.setOrderStatus(LogisticsOrderStatusEnum.ACCEPT.getCode());
        logisticsOrderEntity.setLogisticsId(builder.createSeqNo(SeqBizTypeEnum.LOGISTICS, orderSnapshotEntity.getItemId()));

        logisticsOrderEntity.setConsumerName(orderSnapshotEntity.getConsumerName());
        logisticsOrderEntity.setItemId(orderSnapshotEntity.getItemId());
        logisticsOrderEntity.setItemName(orderSnapshotEntity.getItemName());
        logisticsOrderEntity.setItemNo(orderSnapshotEntity.getItemNo());
        logisticsOrderEntity.setMobile(orderSnapshotEntity.getMobile());
        logisticsOrderEntity.setOrderId(orderSnapshotEntity.getOrderId());
        logisticsOrderEntity.setSkuNo(orderSnapshotEntity.getSkuNo());
        logisticsOrderEntity.setProvince(orderSnapshotEntity.getProvince());
        logisticsOrderService.createLogisticsOrderBatchDelivery(logisticsOrderEntity);

        task.addLogistics(BeanUtils.copy(logisticsOrderEntity,LogisticsOrderDo.class));
    }




}
