package com.qiho.center.biz.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;

import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.common.entityd.qiho.order.DeliveryRecordEntity;

/**
 * DeliveryRecordUtil
 *
 * @Created by zhangshun on 2018-03-10 14:32:22
 */
public class DeliveryRecordUtil {

    private DeliveryRecordUtil() {
    }

    public static DeliveryRecordDto entityToDto(DeliveryRecordEntity entity) {
        if (entity == null) {
            return null;
        }
        DeliveryRecordDto deliveryRecordDto = new DeliveryRecordDto();
        deliveryRecordDto.setId(entity.getId());
        deliveryRecordDto.setMerchantId(entity.getMerchantId());
        deliveryRecordDto.setLogisticsCode(entity.getLogisticsCode());
        deliveryRecordDto.setFileUrl(entity.getFileUrl());
        deliveryRecordDto.setOriginFileName(entity.getOriginFileName());
        deliveryRecordDto.setRemark(entity.getRemark());
        deliveryRecordDto.setRecordType(entity.getRecordType());
        deliveryRecordDto.setTotalCount(entity.getTotalCount());
        deliveryRecordDto.setState(entity.getState());
        deliveryRecordDto.setDeleted(entity.getDeleted());
        deliveryRecordDto.setGmtCreate(entity.getGmtCreate());
        deliveryRecordDto.setGmtModified(entity.getGmtModified());
        return deliveryRecordDto;
    }

    public static List<DeliveryRecordDto> entityListToDtoList(List<DeliveryRecordEntity> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return entityList.stream().map(DeliveryRecordUtil::entityToDto).collect(Collectors.toList());
    }

}
