package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.common.daoh.qihostatistics.BaiqiAppOrderMonitorMapper;
import com.qiho.center.common.entityd.qihostatistics.BaiqiAppOrderMonitorEntity;
import com.qiho.center.common.util.DingTalkUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**媒体订单监控任务
 * @author chensong
 * @create 2018-04-23 16:38
 **/
@Component
public class AppMonitorBo {

    private static final Logger logger = LoggerFactory.getLogger(AppMonitorBo.class);

    @Autowired
    private BaiqiAppOrderMonitorMapper baiqiAppOrderMonitorMapper;

    @Value("${dingtalk.rushorder.url}")
    private String dingTalkRobot;

    /**
     * 媒体订单监控任务
     */
    public void exeTask(){

        // 1.扫描最近两小时未告警的订单记录
        List<BaiqiAppOrderMonitorEntity> orderMonitorList = this.loadData();
        if (CollectionUtils.isEmpty(orderMonitorList)) {
            return;
        }

        // 2.发送钉钉告警
        this.sendDingTalkMsg(orderMonitorList);

        // 3.更新订单的告警状态
        this.updateWarnStatus(orderMonitorList);
    }

    /**
     * 加载数据
     * @return
     */
    private List<BaiqiAppOrderMonitorEntity> loadData(){
        Date endTime = new Date();
        Date startTime = DateUtils.hoursAddOrSub(endTime, -2);
        Map<String,Object> param = Maps.newHashMap();
        param.put("endTime", endTime);
        param.put("startTime", startTime);

        return baiqiAppOrderMonitorMapper.listByParam(param);
    }

    /**
     * 发送钉钉告警消息
     * @param orderMonitorList
     */
    private void sendDingTalkMsg(List<BaiqiAppOrderMonitorEntity> orderMonitorList){
        // 根据appid分组 key:appName-appId  value:List<String> -> orderIdList
        Map<String,List<String>> orderMap = Maps.newHashMap();
        for (BaiqiAppOrderMonitorEntity e : orderMonitorList) {
            String key = new StringBuilder(StringUtils.defaultString(e.getAppName())).append("*").append(e.getAppid()).toString();
            if (orderMap.get(key) == null){
                orderMap.put(key, Lists.newArrayList(e.getOrderId()));
            } else {
                List<String> list = orderMap.get(key);
                list.add(e.getOrderId());
                orderMap.put(key,list);
            }
        }

        StringBuilder msg = new StringBuilder("以下媒体：\n");
        for(String mapKey : orderMap.keySet()){
            int index = mapKey.indexOf("*");
            msg.append("appId:").append(mapKey.substring(index+1)).append("，app名称:").append(mapKey.substring(0,index))
                    .append("，有疑似刷单行为，请及时处理，订单id为:").append(orderMap.get(mapKey).toString()).append("\n");
        }
        DingTalkUtil.sendTextMessageWith(msg.toString(), dingTalkRobot,true);
    }

    /**
     * 更新告警状态
     * @param orderMonitorList
     */
    private void updateWarnStatus(List<BaiqiAppOrderMonitorEntity> orderMonitorList){
        List<Long> idList = orderMonitorList.stream().map(BaiqiAppOrderMonitorEntity::getId).collect(Collectors.toList());
        baiqiAppOrderMonitorMapper.updateWarnByIds(idList);
    }




}
