package com.qiho.center.biz.bo;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.runnable.YunPianNoteSendRunnable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.ExecutorService;

/**
 * Created by danke on 2017/9/8.
 * 用于统一发送捞单短信的bo
 */
@Service
public class NoteGainBo implements ApplicationContextAware {

    private ApplicationContext context;

    @Resource
    private ExecutorService executorService;

    public Boolean sendGainNote(OrderSnapshotDto orderSnapshotDto){
        return this.sendGainNote(Lists.newArrayList(orderSnapshotDto));
    }

    public Boolean sendGainNote(List<OrderSnapshotDto> orderSnapshotDtos){
        //发送短信
        YunPianNoteSendRunnable noteSendTask = context.getBean(YunPianNoteSendRunnable.class);
        noteSendTask.setOrderSnapshotDtos(orderSnapshotDtos);
        executorService.submit(noteSendTask);
        return Boolean.TRUE;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext){
        this.context = applicationContext;
    }
}
