package com.qiho.center.biz.bo;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.WdtOrderAuditParams;
import com.qiho.center.biz.runnable.AuditOrderRunnable;
import com.qiho.center.biz.runnable.WdtAuditOrderRunnable;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.support.BizEventBus;

/**
 * Created by liuyao on 2017/6/5.
 */
@Service
public class OrderBo implements ApplicationContextAware {

    private static final ExecutorService EXECUTOR_ORDER_DELIVERY = new ThreadPoolExecutor(20, 30, 10L,
        TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(200));

    private ApplicationContext context;

    @Autowired
    private OrderService orderService;

    @Autowired
    private OrderSnapshotService orderSnapshotService;

    @Autowired
    private BizEventBus bizEventBus;

    @Resource
    private ExecutorService executorService;

    /**
     * 批量审核订单
     *
     * @param progressKey
     * @param paramList
     *
     * @return
     */
    public Integer batchAuditOrder(String progressKey, List<OrderAuditParams> paramList) {
        AuditOrderRunnable runnable = context.getBean(AuditOrderRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(paramList);
        int enableCount = runnable.enableFilter();
        executorService.submit(runnable);
        return enableCount;
    }

    /**
     * 批量审核订单
     *
     * @param progressKey
     * @param list
     *
     * @return
     */
    public int wdtBatchAuditOrder(String progressKey, List<WdtOrderAuditParams> list) {
        WdtAuditOrderRunnable runnable = context.getBean(WdtAuditOrderRunnable.class);
        runnable.setProgressKey(progressKey);
        runnable.setParams(list);
        EXECUTOR_ORDER_DELIVERY.submit(runnable);
        return 1;
    }

    public void updateOrderStatus(String orderId, OrderStatusEnum orderStatus) {
        orderService.updateOrderStatus(orderId, orderStatus);
        orderSnapshotService.updateOrderStatus(orderId, null, orderStatus, null);
    }

    /**
     * 将主订单变成失败
     *
     * @param orderId
     * @param remark
     * @param orderApprovalStatusEnum
     */
    @Transactional(DsConstants.DATABASE_QIHO)
    public void rejectOrder(String orderId, String remark, OrderApprovalStatusEnum orderApprovalStatusEnum) {
        orderService.rejectOrder(orderId, remark, orderApprovalStatusEnum);
        orderSnapshotService.updateOrderStatus(orderId, remark, OrderStatusEnum.CLOSED, orderApprovalStatusEnum);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }
}
