package com.qiho.center.biz.bo;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.order.PushOrderThirdPartyFailDto;
import com.qiho.center.biz.model.SsjxAddressBean;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.QihoOrderPushThirdPartyFailService;
import com.qiho.center.biz.util.QihoStringUtil;
import com.qiho.center.common.util.BigDecimalUtil;
import com.qiho.center.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * Created by sunchangji on 2018/1/12.
 */
@Component
public class QihoOrderPushThirdPartyFailBo {

    /**
     * 盛世嘉祥商家id
     */
    @Value("${qiho.order.ssjx.merchantid}")
    private String ssjxMerchartId;

    @Resource
    private OrderSnapshotService orderSnapshotService;
    @Resource
    private QihoOrderPushThirdPartyFailService orderPushThirdPartyFailService;

    //盛世嘉祥有充值卡赠品的商品ID
    private static final List<Long> SSJX_WATCH_GIFT_ITEM_IDS = Lists.newArrayList(605L,606L,825L);

    /**
     * 根据条件查询订单同步第三方失败信息
     *
     * @param startTime
     * @param endTime
     * @param merchantId
     * @return
     */
    public List<PushOrderThirdPartyFailDto> findAllByDate(Date startTime, Date endTime, Long merchantId) {
        List<Long> merchantids = new ArrayList<>();
        if (merchantId == null) {
            merchantids = StringUtil.stringToListOrderByIds(ssjxMerchartId);
        }else {
            merchantids.add(merchantId);
        }
        List<String> orderIdList = orderPushThirdPartyFailService.findAllByDate(startTime, endTime, merchantids);
        if (CollectionUtils.isEmpty(orderIdList)) {
            return Collections.emptyList();
        }
        List<OrderSnapshotDto> orderSnapshotDtos = orderSnapshotService.queryOrderByOrderIds(orderIdList);

        return convertToFailDto(orderSnapshotDtos);
    }

    private List<PushOrderThirdPartyFailDto> convertToFailDto(List<OrderSnapshotDto> orderSnapshotDtos) {
        List<PushOrderThirdPartyFailDto> failDtos = new ArrayList<>();
        for (OrderSnapshotDto snapDto : orderSnapshotDtos) {
            String skuName = snapDto.getSkuName() == null ? StringUtils.EMPTY : snapDto.getSkuName();
            String goodsSkuName = snapDto.getItemName() + skuName;
            PushOrderThirdPartyFailDto failDto = new PushOrderThirdPartyFailDto();
            failDto.setGoodstype(snapDto.getItemName());
            String goods0 = goodsSkuName + ",,," + snapDto.getQuantity()+"|";
            String goodsName = goodsSkuName + "*" + snapDto.getQuantity();
            if (SSJX_WATCH_GIFT_ITEM_IDS.contains(snapDto.getItemId())){
                failDto.setGoodsName(goodsName+"，充值卡100元*1");
                failDto.setGoods0(goods0+"充值卡100元,,,1|");
                failDto.setGoodstxm(snapDto.getSkuNo() + "*" + snapDto.getQuantity()+",1001159990002*1");
            }else {
                failDto.setGoods0(goods0);
                failDto.setGoodsName(goodsName);
                failDto.setGoodstxm(snapDto.getSkuNo() + "*" + snapDto.getQuantity());
            }
            failDto.setGoodsPrice(BigDecimalUtil.integerToMove2PointLeft(snapDto.getOrderAmt()).stripTrailingZeros().toPlainString());
            failDto.setName(snapDto.getConsumerName());
            failDto.setTel(snapDto.getMobile());
            SsjxAddressBean addressBean = QihoStringUtil.analyzeSendTime(snapDto.getSendTime());
            if(addressBean != null){
                failDto.setSendTime(addressBean.getSendTime());
                failDto.setProvince3(addressBean.getProvince3());
                failDto.setCity3(addressBean.getCity3());
                failDto.setArea3(addressBean.getArea3());
                failDto.setTownship3(addressBean.getTownship3());
            }
            failDto.setDetailedAddr(snapDto.getAddress() == null ? StringUtils.EMPTY : snapDto.getAddress());
            String addrText = Joiner.on("_").join(QihoStringUtil.excludeNullString(snapDto.getProvince(), snapDto.getCity(), snapDto.getDistrict(), snapDto.getAddress()));
            failDto.setDetailedAddrText(addrText);
            failDto.setMessage(snapDto.getMessage());
            failDto.setIp(snapDto.getIp());
            failDto.setCreateTime(snapDto.getGmtCreate());
            failDto.setOrderId(snapDto.getOrderId());
            failDto.setSid(snapDto.getSid());
            failDtos.add(failDto);
        }

        return failDtos;
    }

}
