package com.qiho.center.biz.bo.domain;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * 快递订阅平台决策结果对象
 * @Author chensong
 * @Create 2019-02-15
 */
public class ExpressPlatformDecideResultBean {

    /** 快递鸟订阅订单 */
    private List<LogisticsOrderDo> expressBirdList;

    /** 快递100订阅订单 */
    private List<LogisticsOrderDo> expressHundredList;

    public List<LogisticsOrderDo> getExpressBirdList() {
        return expressBirdList;
    }

    public void setExpressBirdList(List<LogisticsOrderDo> expressBirdList) {
        this.expressBirdList = expressBirdList;
    }

    public List<LogisticsOrderDo> getExpressHundredList() {
        return expressHundredList;
    }

    public void setExpressHundredList(List<LogisticsOrderDo> expressHundredList) {
        this.expressHundredList = expressHundredList;
    }

    public ExpressPlatformDecideResultBean(){
        super();
        expressBirdList = Lists.newArrayList();
        expressHundredList = Lists.newArrayList();
    }

    /**
     * 添加快递鸟订阅订单
     * @param logisticsOrderDo
     */
    public void addBirdOrder(LogisticsOrderDo logisticsOrderDo) {
        this.expressBirdList.add(logisticsOrderDo);
    }

    /**
     * 添加快递100订阅订单
     * @param logisticsOrderDo
     */
    public void addHundredOrder(LogisticsOrderDo logisticsOrderDo){
        this.expressHundredList.add(logisticsOrderDo);
    }

}
