package com.qiho.center.biz.engine.coupon;

/**
 * Created by danke on 2017/6/21.
 * T :校验参数的封装
 */
public class AstrictFactory {

    private AstrictFactory(){

    }

    /**
     * 创建校验限制执行上下文
     * @return
     */
    public static <T,V> AstrictContext<T,V> createAstrictContext(T astrictVal,V verifyModle){
        return new AstrictContext(astrictVal,verifyModle);
    }

    /**
     * 创建校验参数上下文
     * 入参为检验限制参数,因为有些校验只需要用到一个参数,兼容方法
     * @param astrictVal
     * @param <T>
     * @param <V>
     * @return
     */
    public static <T,V> AstrictContext<T,V> createContextAsNotVerfiy(T astrictVal){
        return createAstrictContext(astrictVal,null);
    }

}
