package com.qiho.center.biz.engine.task;

import com.qiho.center.api.constant.OrderRemarkConstant;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.service.order.AnticheateService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.entity.order.QihoAnticheateEntity;

import javax.annotation.Resource;

/**
 * Created by qianjue on 2017/8/1.
 */
public class OrderAuditRejectTask implements BaseEngine<ProcessContext> {

	@Resource
	private AnticheateService  anticheateService;

	@Resource
	private OrderService  orderService;

	/**
	 * 命中审核不通过的后续处理
	 *
	 * update note : 当命中审核不通过时，备注记录从此处取{@link OrderRemarkConstant#SHOTORDER_STRATEGY_REJECTION}
	 *
	 * @param processContext
	 * @return
	 */
	@Override
	public ProcessContext process(ProcessContext processContext){
		if(null == processContext || null == processContext.getOrderSnapshotDto() || null == processContext.getStrategyDto()){
			//上线文为空,不做策略处理
			return processContext;
		}
		OrderSnapshotDto orderSnapshotDto = processContext.getOrderSnapshotDto();
		QihoAnticheateEntity qihoAnticheateEntity = new QihoAnticheateEntity();
		qihoAnticheateEntity.setOrderId(orderSnapshotDto.getOrderId());
		qihoAnticheateEntity.setRule(processContext.getStrategyDto().getStrategyName());
		qihoAnticheateEntity.setMobile(orderSnapshotDto.getMobile());
		anticheateService.insert(qihoAnticheateEntity);
		OrderAuditParams params = new OrderAuditParams();
		params.setOrderId(orderSnapshotDto.getOrderId());

		params.setRemark(OrderRemarkConstant.SHOTORDER_STRATEGY_REJECTION);
		params.setAuditResult(OrderAuditParams.AUDIT_FAILED);
		orderService.auditOrder(params);
		//将中断参数设置为true,表示需要中断操作,无需进行后续处理
		processContext.setNeedBroken(true);
		return processContext;
	}

}
