package com.qiho.center.biz.engine.task.filter;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.bklist.BaiqiBlackListDto;
import com.qiho.center.api.enums.DealTypeEnum;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.blacklist.BaiqiBlackListTypeEnum;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.api.enums.blacklist.SourceTypeEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpRiskCheckFailEnum;
import com.qiho.center.biz.service.blacklist.BaiqiBlackListService;
import com.qiho.center.biz.service.ordertmp.OrderTmpService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 用于过滤规则命中订单的处理
 * @author chensong
 * @create 2018-07-12
 */
@Component
public class FilterOrderTask  {

    private static final Logger LOGGER = LoggerFactory.getLogger(FilterOrderTask.class);

    @Autowired
    private OrderTmpService orderTmpService;

    @Autowired
    private BaiqiBlackListService baiqiBlackListService;

    /**
     * 订单命中过滤规则的后续处理
     * @param snapshotDto
     * @param handleResult
     */
    public void postFilterRuleHandle(OrderSnapshotDto snapshotDto, Set<String> handleResult){
        if (snapshotDto == null || CollectionUtils.isEmpty(handleResult)) {
            return;
        }

        if (handleResult.contains(ShotOrderHandlerEnum.INVALID_AND_BLACK.getVal())) {
            // 将订单置为无效并且手机号加入黑名单
            orderTmpService.updateOrderTmpToInvalid(snapshotDto.getOrderId(),
                    "过滤规则不通过", OrderTmpRiskCheckFailEnum.FILTER_ORDER_RULE_FAIL);

            // 将手机号添加到黑名单中
            addMobileIntoBlackList(snapshotDto);

        } else if (handleResult.contains(ShotOrderHandlerEnum.ORDER_INVALID.getVal())) {
            // 将订单置为无效
            orderTmpService.updateOrderTmpToInvalid(snapshotDto.getOrderId(),
                    "过滤规则不通过", OrderTmpRiskCheckFailEnum.FILTER_ORDER_RULE_FAIL);
        }
    }

    /**
     * 将手机号添加到黑名单
     * @param snapshotDto
     */
    private void addMobileIntoBlackList(OrderSnapshotDto snapshotDto){
        BaiqiBlackListDto blackListDto = new BaiqiBlackListDto();
        blackListDto.setBkType(BaiqiBlackListTypeEnum.PHONE);
        blackListDto.setDealType(DealTypeEnum.FORBID_SUBMIT);
        blackListDto.setSourceType(SourceTypeEnum.MANUAL);
        blackListDto.setUseType(BlackListUseTypeEnum.ALL);
        blackListDto.setBkValue(snapshotDto.getMobile());
        blackListDto.setRemark("多次命中现有规则");
        blackListDto.setMerchantId(0L);

        baiqiBlackListService.simpleAddBlackList(blackListDto);
    }


}
