/**
 * Project Name:qiho-center-biz File Name:LogisticsUpdateEvent.java Package Name:com.qiho.center.biz.event
 * Date:2017年6月13日下午2:11:47 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.event;

import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.common.annotations.AsyncEvent;

import java.util.Map;

/**
 * ClassName:LogisticsUpdateEvent <br/>
 * 物流状态更新事件. <br/>
 * Date: 2017年6月13日 下午2:11:47 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@AsyncEvent
public class LogisticsUpdateEvent {

    /** 订单ID */
    private String                 orderId;

    /** 圆通物流状态 */
    private YTOLogisticsStatusEnum logisticsStatus;

    /**
     * 奇货系统订单状态
     */
    private LogisticsOrderStatusEnum logisticsOrderStatusEnum;

    /** 操作员的姓名、手机号信息 */
    private Map<String,String>     deliveryMsg;

    /**
     * 快递公司代码
     */
    private String logisticsCode;

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * logisticsStatus.
     *
     * @return the logisticsStatus
     */
    public YTOLogisticsStatusEnum getLogisticsStatus() {
        return logisticsStatus;
    }

    /**
     * logisticsStatus.
     *
     * @param logisticsStatus the logisticsStatus to set
     */
    public void setLogisticsStatus(YTOLogisticsStatusEnum logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    public Map<String, String> getDeliveryMsg() {
        return deliveryMsg;
    }

    public void setDeliveryMsg(Map<String, String> deliveryMsg) {
        this.deliveryMsg = deliveryMsg;
    }

    public LogisticsOrderStatusEnum getLogisticsOrderStatusEnum() {
        return logisticsOrderStatusEnum;
    }

    public void setLogisticsOrderStatusEnum(LogisticsOrderStatusEnum logisticsOrderStatusEnum) {
        this.logisticsOrderStatusEnum = logisticsOrderStatusEnum;
    }

    public String getLogisticsCode() {
        return logisticsCode;
    }

    public void setLogisticsCode(String logisticsCode) {
        this.logisticsCode = logisticsCode;
    }
}
