package com.qiho.center.biz.job;

import java.util.Calendar;
import java.util.Date;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.service.finance.FinanceDetailService;

/**
 * Created by jiafeng.geng on 2018-03-22 10:59:09.
 */
@Component
public class FinanceHistoricalBalanceSyncJob extends AbstractQihoSimpleElasticJob {

    private static Logger LOGGER = LoggerFactory.getLogger(FinanceHistoricalBalanceSyncJob.class);

    @Resource
    private FinanceDetailService financeDetailService;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {

        LOGGER.warn("FinanceHistoricalBalanceSyncJob start");
        // 定时同步财务信息历史余额
        if (financeDetailService.historicalBalanceSync()) {
            LOGGER.warn("FinanceHistoricalBalanceSyncJob success");
        } else {
            LOGGER.warn("FinanceHistoricalBalanceSyncJob failed");
        }
    }

}
