package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.enums.KuaiDi100LogisticsOrderStatusEnum;
import com.qiho.center.biz.bo.ExpressBo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.common.constant.Environment;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.util.AppLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 快递100重复订阅任务
 * Author: zhanghuifeng
 * Date:   16:03 2017/11/21
 */
@Component
public class KuaiDi100AgainPostOrderJob extends AbstractQihoSimpleElasticJob {

	private static final Logger LOGGER = LoggerFactory.getLogger(KuaiDi100AgainPostOrderJob.class);

	@Resource
	private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
	@Resource
	private ExpressBo expressBo;

	@Override
	protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
		//只有线上环境才执行
		if (!Environment.isOnline()){
			return;
		}
		//查询物流子订单中 疑难状态订单
		AppLogUtil.info(LOGGER, "开始执行定时任务【KuaiDi100AgainPostOrderJob】 ");
		LOGGER.info("开始执行定时任务【KuaiDi100AgainPostOrderJob】");
		int pageSize = 100;
		int pageNum = 1;
		long minId = 0;
		while (true) {
			List<LogisticsOrderEntity> list = qihoLogisticsOrderDAO.findByLogisticsStatus(pageNum, pageSize,minId, KuaiDi100LogisticsOrderStatusEnum.PUZZLE.getDesc());
			if (CollectionUtils.isEmpty(list)) {
				break;
			}

			expressBo.subscribeExpress(BeanUtils.copyList(list,LogisticsOrderDo.class));
			minId = list.get(list.size()-1).getId();
		}
	}

}
