package com.qiho.center.biz.job;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.LogisticsCloseBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 物流子订单超时关闭任务
 *
 * @Author chensong
 * @Create 2019-02-18
 */
@Component
public class LogisticsTimeOutCloseJob extends AbstractQihoSimpleElasticJob {

    private static final Logger logger = LoggerFactory.getLogger(LogisticsTimeOutCloseJob.class);

    @Autowired
    private LogisticsCloseBO logisticsCloseBO;

    @Override
    public void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        logger.info("物流子订单超时关闭任务开始");
        DBTimeProfile.enter("LogisticsTimeOutCloseJob.doProcess");

        try {
            logisticsCloseBO.doLogisticsCloseTask();
        } catch (Exception e) {
            logger.error("物流子订单超时关闭任务异常！", e);
        }

        DBTimeProfile.release();
        logger.info("物流子订单超时关闭任务结束");
    }




}
