package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.MediaOrderBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Description:媒体订单监控定时任务
 *             每小时的20分启动一次
 * @author chensong
 * @create 2018-06-14
 */
@Component
public class MediaOrderJob extends AbstractQihoSimpleElasticJob  {

    private final static Logger LOGGER = LoggerFactory.getLogger(MediaOrderJob.class);

    @Autowired
    private MediaOrderBo mediaOrderBo;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.info("媒体订单防作弊监控定时任务启动");
        mediaOrderBo.doTask();
        LOGGER.info("媒体订单防作弊监控定时任务结束");
    }


}
