package com.qiho.center.biz.job;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.biz.bo.OrderSmsTimeOutBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/** 短信超时处理任务
 *  两分钟执行一次
 * @author chensong
 * @create 2018-05-22 14:23
 **/
@Component
public class OrderSmsTimeOutJob extends AbstractQihoSimpleElasticJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderSmsTimeOutJob.class);

    @Autowired
    private OrderSmsTimeOutBo orderSmsTimeOutBo;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {

        LOGGER.info("短信超时处理任务开始执行");
        orderSmsTimeOutBo.doJob();
        LOGGER.info("短信超时处理任务结束");
    }
}
