package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.common.daoh.qihostatistics.SkuDaySaleMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;

/**
 * Created by weny.cai on 2018/1/16.
 */
@Component
public class SkuDaySaleClearJob extends AbstractQihoSimpleElasticJob  {

    private static final Logger LOGGER = LoggerFactory.getLogger(SkuDaySaleClearJob.class);

    @Resource
    SkuDaySaleMapper skuDaySaleMapper;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE,-7);
        cal.set(Calendar.HOUR_OF_DAY, 0);//时
        cal.set(Calendar.MINUTE, 0);//分
        cal.set(Calendar.SECOND, 0);//秒
        String clearDate = DateUtils.getSecondStr(cal.getTime());
        int result = skuDaySaleMapper.deleteByClearDate(clearDate);
        LOGGER.info("清理了{}条业务日志数据",result);
    }

}
