package com.qiho.center.biz.process.note.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import com.qiho.center.common.util.SimpleTemplateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;


/**
 * 创蓝短信
 * @author: wangjin
 * @create 2018-04-18 14:02
 **/
@Component
public class CLSmsProcessImpl implements SmsProcess,InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(CLSmsProcessImpl.class);


    @Value("${chuanglan.sms.url}")
    private String smsUrl;

    @Value("${chuanglan.sms.account}")
    private String account;

    @Value("${chuanglan.sms.password}")
    private String password;

    /**
     * 返回成功码
     */
    private static final String SUCCESS_CODE = "0";

    /**
     * 状态属性
     */
    private static final String CODE_NAME = "code";

    @Override
    public boolean smsSendByParam(QihoTemplateEntity template, Map<String, String> param, String mobile) {

        // 1、获取短信模板内容
        String context = getStrTemplate(template, param);

        // 2、发送短信，拿到返回结果
        String res = smsSend(context,mobile,template.getReport());

        // 3、根据结果判断返回true/falsex
        if(StringUtils.isNotBlank(res)){
            JSONObject clObject = JSON.parseObject(res);
            // 判断是否返回成功
            return StringUtils.equals(SUCCESS_CODE, (String) clObject.get(CODE_NAME));
        }
        return false;
    }

    @Override
    public String smsSendByParamRetCode(QihoTemplateEntity template, Map<String, String> param, String mobile) {
        String context = getStrTemplate(template, param);
        return smsSend(context,mobile,template.getReport());
    }

    @Override
    public boolean smsSend(QihoTemplateEntity template, String mobile) {
        String res = smsSend(template.getTemplateContext(),mobile,template.getReport());
        JSONObject clObject = JSON.parseObject(res);
        // 判断是否返回成功
        if (StringUtils.equals((String)clObject.get(CODE_NAME), SUCCESS_CODE)){
            return true;
        }else {
            return false;
        }
    }

    @Override
    public String smsSendRetCode(QihoTemplateEntity template, String mobile) {
        return smsSend(template.getTemplateContext(),mobile,template.getReport());
    }

    public String smsSend(String content, String mobile, Boolean report) {

        // 设置创蓝短信平台所需参数
        Map<String, String> params = new HashMap<>(16);
        params.put("account", account);
        params.put("password", password);
        params.put("phone", mobile);
        params.put("msg",content);
        params.put("report",String.valueOf(report));

        String jsonData = JSONObject.toJSONString(params);

        String resp ;

        try {
            // 执行请求，返回String结果
            resp = HttpClientUtil.sendPostJson(smsUrl, jsonData);
            if (StringUtils.isNotBlank(resp)){
                JSONObject clObject = JSON.parseObject(resp);
                // 判断短信是否发送成功
                if (!StringUtils.equals((String)clObject.get(CODE_NAME), SUCCESS_CODE)){
                    AppLogUtil.warn(LOGGER, "创蓝发送短信异常， mobile={}, content={}, resp={}", mobile, content, resp);
                }

                return resp;
            }
        } catch (Exception e){
            LOGGER.error("创蓝发送短信失败：mobile={}", mobile, e);
        }

        return "";
    }

    /**
     * 创蓝需要组装短信模板,
     *
     * @return
     */
    private String getStrTemplate(QihoTemplateEntity template, Map<String, String> param) {
        return SimpleTemplateUtil.render(template.getTemplateContext(), param);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SmsProcessFactory.registPaychannel(SmsTypeEnum.CHUANG_LAN, this);
    }
}
